/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.impl;

import java.security.Provider;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpConstants;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.impl.BasicAuthenticationMechanism;
import org.wildfly.security.http.impl.BearerTokenAuthenticationMechanism;
import org.wildfly.security.http.impl.ClientCertAuthenticationMechanism;
import org.wildfly.security.http.impl.DigestAuthenticationMechanism;
import org.wildfly.security.http.impl.FormAuthenticationMechanism;
import org.wildfly.security.http.impl.NonceManager;
import org.wildfly.security.http.impl.SpnegoAuthenticationMechanism;
import org.wildfly.security.util.ProviderUtil;

public class ServerMechanismFactoryImpl
implements HttpServerAuthenticationMechanismFactory {
    private final Supplier<Provider[]> providers;
    private static NonceManager nonceManager = new NonceManager(300000L, 900000L, true, 20, "SHA-256", ElytronMessages.httpDigest);

    public ServerMechanismFactoryImpl() {
        this.providers = ProviderUtil.INSTALLED_PROVIDERS;
    }

    public ServerMechanismFactoryImpl(Provider provider) {
        this.providers = () -> new Provider[]{provider};
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        ArrayList<String> mechanismNames = new ArrayList<String>();
        mechanismNames.add("BASIC");
        mechanismNames.add("CLIENT_CERT");
        mechanismNames.add("DIGEST");
        mechanismNames.add("DIGEST-SHA-256");
        mechanismNames.add("DIGEST-SHA-512-256");
        mechanismNames.add("FORM");
        mechanismNames.add("SPNEGO");
        mechanismNames.add("BEARER_TOKEN");
        return mechanismNames.toArray(new String[mechanismNames.size()]);
    }

    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        Assert.checkNotNullParam((String)"mechanismName", (Object)mechanismName);
        Assert.checkNotNullParam((String)"properties", properties);
        Assert.checkNotNullParam((String)"callbackHandler", (Object)callbackHandler);
        switch (mechanismName) {
            case "BASIC": {
                return new BasicAuthenticationMechanism(callbackHandler, (String)properties.get(HttpConstants.CONFIG_REALM), false);
            }
            case "CLIENT_CERT": {
                return new ClientCertAuthenticationMechanism(callbackHandler);
            }
            case "DIGEST": {
                return new DigestAuthenticationMechanism(callbackHandler, nonceManager, (String)properties.get(HttpConstants.CONFIG_REALM), (String)properties.get(HttpConstants.CONFIG_CONTEXT_PATH), "DIGEST", "MD5", this.providers, (String)properties.get(HttpConstants.CONFIG_VALIDATE_DIGEST_URI));
            }
            case "DIGEST-SHA-256": {
                return new DigestAuthenticationMechanism(callbackHandler, nonceManager, (String)properties.get(HttpConstants.CONFIG_REALM), (String)properties.get(HttpConstants.CONFIG_CONTEXT_PATH), "DIGEST-SHA-256", "SHA-256", this.providers, (String)properties.get(HttpConstants.CONFIG_VALIDATE_DIGEST_URI));
            }
            case "DIGEST-SHA-512-256": {
                return new DigestAuthenticationMechanism(callbackHandler, nonceManager, (String)properties.get(HttpConstants.CONFIG_REALM), (String)properties.get(HttpConstants.CONFIG_CONTEXT_PATH), "DIGEST-SHA-512-256", "SHA-512-256", this.providers, (String)properties.get(HttpConstants.CONFIG_VALIDATE_DIGEST_URI));
            }
            case "FORM": {
                return new FormAuthenticationMechanism(callbackHandler, properties);
            }
            case "SPNEGO": {
                return new SpnegoAuthenticationMechanism(callbackHandler, properties);
            }
            case "BEARER_TOKEN": {
                return new BearerTokenAuthenticationMechanism(callbackHandler);
            }
        }
        return null;
    }
}

