/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Locale;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.ssl.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void warnInvalidStringCountForMechanismDatabaseEntry(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.warnInvalidStringCountForMechanismDatabaseEntry$str(), (Object)name);
    }

    protected String warnInvalidStringCountForMechanismDatabaseEntry$str() {
        return "ELY01066: Invalid string count for mechanism database entry \"%s\"";
    }

    @Override
    public final void warnInvalidKeyExchangeForMechanismDatabaseEntry(String value, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.warnInvalidKeyExchangeForMechanismDatabaseEntry$str(), (Object)value, (Object)name);
    }

    protected String warnInvalidKeyExchangeForMechanismDatabaseEntry$str() {
        return "ELY01067: Invalid key exchange \"%s\" for mechanism database entry \"%s\"";
    }

    @Override
    public final void warnInvalidAuthenticationForMechanismDatabaseEntry(String value, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.warnInvalidAuthenticationForMechanismDatabaseEntry$str(), (Object)value, (Object)name);
    }

    protected String warnInvalidAuthenticationForMechanismDatabaseEntry$str() {
        return "ELY01068: Invalid authentication \"%s\" for mechanism database entry \"%s\"";
    }

    @Override
    public final void warnInvalidEncryptionForMechanismDatabaseEntry(String value, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.warnInvalidEncryptionForMechanismDatabaseEntry$str(), (Object)value, (Object)name);
    }

    protected String warnInvalidEncryptionForMechanismDatabaseEntry$str() {
        return "ELY01069: Invalid encryption \"%s\" for mechanism database entry \"%s\"";
    }

    @Override
    public final void warnInvalidDigestForMechanismDatabaseEntry(String value, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.warnInvalidDigestForMechanismDatabaseEntry$str(), (Object)value, (Object)name);
    }

    protected String warnInvalidDigestForMechanismDatabaseEntry$str() {
        return "ELY01070: Invalid digest \"%s\" for mechanism database entry \"%s\"";
    }

    @Override
    public final void warnInvalidProtocolForMechanismDatabaseEntry(String value, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.warnInvalidProtocolForMechanismDatabaseEntry$str(), (Object)value, (Object)name);
    }

    protected String warnInvalidProtocolForMechanismDatabaseEntry$str() {
        return "ELY01071: Invalid protocol \"%s\" for mechanism database entry \"%s\"";
    }

    @Override
    public final void warnInvalidLevelForMechanismDatabaseEntry(String value, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.warnInvalidLevelForMechanismDatabaseEntry$str(), (Object)value, (Object)name);
    }

    protected String warnInvalidLevelForMechanismDatabaseEntry$str() {
        return "ELY01072: Invalid level \"%s\" for mechanism database entry \"%s\"";
    }

    @Override
    public final void warnInvalidStrengthBitsForMechanismDatabaseEntry(String value, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.warnInvalidStrengthBitsForMechanismDatabaseEntry$str(), (Object)value, (Object)name);
    }

    protected String warnInvalidStrengthBitsForMechanismDatabaseEntry$str() {
        return "ELY01073: Invalid strength bits \"%s\" for mechanism database entry \"%s\"";
    }

    @Override
    public final void warnInvalidAlgorithmBitsForMechanismDatabaseEntry(String value, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.warnInvalidAlgorithmBitsForMechanismDatabaseEntry$str(), (Object)value, (Object)name);
    }

    protected String warnInvalidAlgorithmBitsForMechanismDatabaseEntry$str() {
        return "ELY01074: Invalid algorithm bits \"%s\" for mechanism database entry \"%s\"";
    }

    @Override
    public final void warnInvalidDuplicateMechanismDatabaseEntry(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.warnInvalidDuplicateMechanismDatabaseEntry$str(), (Object)name);
    }

    protected String warnInvalidDuplicateMechanismDatabaseEntry$str() {
        return "ELY01075: Invalid duplicate mechanism database entry \"%s\"";
    }

    @Override
    public final void warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry(String alias, String name, String originalName) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry$str(), (Object)alias, (Object)name, (Object)originalName);
    }

    protected String warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry$str() {
        return "ELY01076: Invalid duplicate OpenSSL-style alias \"%s\" for mechanism database entry \"%s\" (original is \"%s\")";
    }

    @Override
    public final void warnInvalidAliasForMissingMechanismDatabaseEntry(String value, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.warnInvalidAliasForMissingMechanismDatabaseEntry$str(), (Object)value, (Object)name);
    }

    protected String warnInvalidAliasForMissingMechanismDatabaseEntry$str() {
        return "ELY01077: Invalid alias \"%s\" for missing mechanism database entry \"%s\"";
    }

    protected String noAlgorithmForSslProtocol$str() {
        return "ELY04001: No algorithm found matching TLS/SSL protocol selection criteria";
    }

    @Override
    public final NoSuchAlgorithmException noAlgorithmForSslProtocol() {
        NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.noAlgorithmForSslProtocol$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String emptyChainNotTrusted$str() {
        return "ELY04002: Empty certificate chain is not trusted";
    }

    @Override
    public final CertificateException emptyChainNotTrusted() {
        CertificateException result = new CertificateException(String.format(this.getLoggingLocale(), this.emptyChainNotTrusted$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notTrustedRealmProblem$str() {
        return "ELY04003: Certificate not trusted due to realm failure for principal [%s]";
    }

    @Override
    public final CertificateException notTrustedRealmProblem(RealmUnavailableException e, Principal principal) {
        CertificateException result = new CertificateException(String.format(this.getLoggingLocale(), this.notTrustedRealmProblem$str(), principal), e);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notTrusted$str() {
        return "ELY04004: Credential validation failed: certificate is not trusted for principal [%s]";
    }

    @Override
    public final CertificateException notTrusted(Principal principal) {
        CertificateException result = new CertificateException(String.format(this.getLoggingLocale(), this.notTrusted$str(), principal));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noDefaultTrustManager$str() {
        return "ELY04005: No default trust manager available";
    }

    @Override
    public final NoSuchAlgorithmException noDefaultTrustManager() {
        NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.noDefaultTrustManager$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noContextForSslConnection$str() {
        return "ELY04006: No context for SSL connection";
    }

    @Override
    public final SSLHandshakeException noContextForSslConnection() {
        SSLHandshakeException result = new SSLHandshakeException(String.format(this.getLoggingLocale(), this.noContextForSslConnection$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sslClosed$str() {
        return "ELY04007: SSL channel is closed";
    }

    @Override
    public final SSLException sslClosed() {
        SSLException result = new SSLException(String.format(this.getLoggingLocale(), this.sslClosed$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notHandshakeRecord$str() {
        return "ELY04008: Initial SSL/TLS data is not a handshake record";
    }

    @Override
    public final SSLHandshakeException notHandshakeRecord() {
        SSLHandshakeException result = new SSLHandshakeException(String.format(this.getLoggingLocale(), this.notHandshakeRecord$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidHandshakeRecord$str() {
        return "ELY04009: Initial SSL/TLS handshake record is invalid";
    }

    @Override
    public final SSLHandshakeException invalidHandshakeRecord() {
        SSLHandshakeException result = new SSLHandshakeException(String.format(this.getLoggingLocale(), this.invalidHandshakeRecord$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multiRecordSSLHandshake$str() {
        return "ELY04010: Initial SSL/TLS handshake spans multiple records";
    }

    @Override
    public final SSLHandshakeException multiRecordSSLHandshake() {
        SSLHandshakeException result = new SSLHandshakeException(String.format(this.getLoggingLocale(), this.multiRecordSSLHandshake$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String expectedClientHello$str() {
        return "ELY04011: Expected \"client hello\" record";
    }

    @Override
    public final SSLHandshakeException expectedClientHello() {
        SSLHandshakeException result = new SSLHandshakeException(String.format(this.getLoggingLocale(), this.expectedClientHello$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedSslRecord$str() {
        return "ELY04012: Unsupported SSL/TLS record";
    }

    @Override
    public final SSLHandshakeException unsupportedSslRecord() {
        SSLHandshakeException result = new SSLHandshakeException(String.format(this.getLoggingLocale(), this.unsupportedSslRecord$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTlsExt$str() {
        return "ELY04013: Invalid TLS extension data";
    }

    @Override
    public final SSLProtocolException invalidTlsExt() {
        SSLProtocolException result = new SSLProtocolException(String.format(this.getLoggingLocale(), this.invalidTlsExt$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notEnoughData$str() {
        return "ELY04014: Not enough data in record to fill declared item size";
    }

    @Override
    public final SSLProtocolException notEnoughData() {
        SSLProtocolException result = new SSLProtocolException(String.format(this.getLoggingLocale(), this.notEnoughData$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String emptyHostNameSni$str() {
        return "ELY04015: Empty host name in SNI record data";
    }

    @Override
    public final SSLProtocolException emptyHostNameSni() {
        SSLProtocolException result = new SSLProtocolException(String.format(this.getLoggingLocale(), this.emptyHostNameSni$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicatedSniServerName$str() {
        return "ELY04016: Duplicated SNI server name of type %d";
    }

    @Override
    public final SSLProtocolException duplicatedSniServerName(int type) {
        SSLProtocolException result = new SSLProtocolException(String.format(this.getLoggingLocale(), this.duplicatedSniServerName$str(), type));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownAuthenticationName$str() {
        return "ELY04017: Unknown authentication name \"%s\"";
    }

    @Override
    public final IllegalArgumentException unknownAuthenticationName(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownAuthenticationName$str(), name));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownEncryptionName$str() {
        return "ELY04018: Unknown encryption name \"%s\"";
    }

    @Override
    public final IllegalArgumentException unknownEncryptionName(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownEncryptionName$str(), name));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownKeyExchangeName$str() {
        return "ELY04019: Unknown key exchange name \"%s\"";
    }

    @Override
    public final IllegalArgumentException unknownKeyExchangeName(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownKeyExchangeName$str(), name));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidClientMode$str() {
        return "ELY04024: Invalid client mode, expected %s, got %s";
    }

    @Override
    public final IllegalArgumentException invalidClientMode(boolean expectedMode, boolean givenMode) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidClientMode$str(), expectedMode, givenMode));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sslErrorCreatingTrustManager$str() {
        return "ELY04026: Could not create trust manager [%s]";
    }

    @Override
    public final IllegalStateException sslErrorCreatingTrustManager(String name, Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.sslErrorCreatingTrustManager$str(), name), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String securityDomainOfSSLContextDoesNotSupportX509$str() {
        return "ELY04027: SecurityDomain of SSLContext does not support X509PeerCertificateChainEvidence verification";
    }

    @Override
    public final IllegalArgumentException securityDomainOfSSLContextDoesNotSupportX509() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.securityDomainOfSSLContextDoesNotSupportX509$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String defaultContextCannotBeNull$str() {
        return "ELY04029: Default context cannot be null";
    }

    @Override
    public final IllegalStateException defaultContextCannotBeNull() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.defaultContextCannotBeNull$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSNIContextForSslConnection$str() {
        return "ELY04030: No context for SSL connection";
    }

    @Override
    public final SSLException noSNIContextForSslConnection() {
        SSLException result = new SSLException(String.format(this.getLoggingLocale(), this.noSNIContextForSslConnection$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sslErrorCreatingRevocationTrustManager$str() {
        return "ELY04031: TrustManagerFactory algorithm [%s] does not support certificate revocation";
    }

    @Override
    public final IllegalStateException sslErrorCreatingRevocationTrustManager(String name, Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.sslErrorCreatingRevocationTrustManager$str(), name), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mechSelectorUnexpectedChar$str() {
        return "ELY05015: Unexpected character U+%04x at offset %d of mechanism selection string \"%s\"";
    }

    @Override
    public final IllegalArgumentException mechSelectorUnexpectedChar(int codePoint, long offset, String string) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mechSelectorUnexpectedChar$str(), codePoint, offset, string));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mechSelectorUnknownToken$str() {
        return "ELY05016: Unrecognized token \"%s\" in mechanism selection string \"%s\"";
    }

    @Override
    public final IllegalArgumentException mechSelectorUnknownToken(String word, String string) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mechSelectorUnknownToken$str(), word, string));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mechSelectorTokenNotAllowed$str() {
        return "ELY05017: Token \"%s\" not allowed at offset %d of mechanism selection string \"%s\"";
    }

    @Override
    public final IllegalArgumentException mechSelectorTokenNotAllowed(String token, long offset, String string) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mechSelectorTokenNotAllowed$str(), token, offset, string));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownCipherSuiteName$str() {
        return "ELY15000: Uknown cipher suite name '%s' in names string '%s'";
    }

    @Override
    public final IllegalArgumentException unknownCipherSuiteName(String name, String string) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownCipherSuiteName$str(), name, string));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

