/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.jaspi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.module.ServerAuthModule;
import org.wildfly.security.auth.jaspi.Flag;
import org.wildfly.security.auth.jaspi._private.ElytronMessages;
import org.wildfly.security.auth.jaspi.impl.AuthenticationModuleDefinition;
import org.wildfly.security.auth.jaspi.impl.ElytronAuthConfigProvider;

public final class JaspiConfigurationBuilder {
    private final String messageLayer;
    private final String applicationContext;
    private String description;
    private List<AuthenticationModuleDefinition> serverAuthModules = new ArrayList<AuthenticationModuleDefinition>();
    private boolean registered = false;

    private JaspiConfigurationBuilder(String messageLayer, String applicationContext) {
        this.messageLayer = messageLayer;
        this.applicationContext = applicationContext;
    }

    public JaspiConfigurationBuilder setDescription(String description) {
        this.assertNotRegistered();
        this.description = description;
        return this;
    }

    public JaspiConfigurationBuilder addAuthModuleFactory(Supplier<ServerAuthModule> serverAuthModuleFactory) {
        return this.addAuthModuleFactory(serverAuthModuleFactory, Flag.REQUIRED, Collections.EMPTY_MAP);
    }

    public JaspiConfigurationBuilder addAuthModuleFactory(Supplier<ServerAuthModule> serverAuthModuleFactory, Flag flag, Map options) {
        this.assertNotRegistered();
        this.serverAuthModules.add(new AuthenticationModuleDefinition(serverAuthModuleFactory, flag, options));
        return this;
    }

    public String register() {
        return this.register(AuthConfigFactory.getFactory());
    }

    public String register(AuthConfigFactory authConfigFactory) {
        this.assertNotRegistered();
        this.registered = true;
        return authConfigFactory.registerConfigProvider((AuthConfigProvider)new ElytronAuthConfigProvider(this.messageLayer, this.applicationContext, this.serverAuthModules), this.messageLayer, this.applicationContext, this.description);
    }

    private void assertNotRegistered() {
        if (this.registered) {
            throw ElytronMessages.log.configAlreadyRegistered(this.messageLayer, this.applicationContext);
        }
    }

    public static JaspiConfigurationBuilder builder(String messageLayer, String applicationContext) {
        return new JaspiConfigurationBuilder(messageLayer, applicationContext);
    }
}

