/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.callback;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.auth.callback.SocketAddressCallback;

public final class SocketAddressQueryCallbackHandler
implements CallbackHandler {
    private final CallbackHandler delegate;
    private final SocketAddress localAddress;
    private final SocketAddress peerAddress;
    private final AtomicBoolean once = new AtomicBoolean();

    public SocketAddressQueryCallbackHandler(CallbackHandler delegate, SocketAddress localAddress, SocketAddress peerAddress) {
        this.delegate = delegate;
        this.localAddress = localAddress;
        this.peerAddress = peerAddress;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        Callback[] newCallbacks;
        if (this.localAddress == null && this.peerAddress == null || !this.once.compareAndSet(false, true)) {
            this.delegate.handle(callbacks);
            return;
        }
        SocketAddressCallback localCallback = this.localAddress == null ? null : new SocketAddressCallback(this.localAddress, SocketAddressCallback.Kind.LOCAL);
        SocketAddressCallback peerCallback = this.peerAddress == null ? null : new SocketAddressCallback(this.peerAddress, SocketAddressCallback.Kind.PEER);
        int length = callbacks.length;
        if (localCallback != null && peerCallback != null) {
            newCallbacks = new Callback[length + 2];
            newCallbacks[0] = localCallback;
            newCallbacks[1] = peerCallback;
            System.arraycopy(callbacks, 0, newCallbacks, 2, length);
        } else if (localCallback != null) {
            newCallbacks = new Callback[length + 1];
            newCallbacks[0] = localCallback;
            System.arraycopy(callbacks, 0, newCallbacks, 1, length);
        } else {
            newCallbacks = new Callback[length + 1];
            newCallbacks[0] = peerCallback;
            System.arraycopy(callbacks, 0, newCallbacks, 1, length);
        }
        try {
            this.delegate.handle(newCallbacks);
        }
        catch (UnsupportedCallbackException e) {
            if (e.getCallback() instanceof SocketAddressCallback) {
                this.delegate.handle(callbacks);
                return;
            }
            throw e;
        }
    }
}

