/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.token._private;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.wildfly.security.auth.server.RealmUnavailableException;

@MessageLogger(projectCode="ELY", length=5)
public interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security");

    @Message(id=1104, value="OAuth2-based realm failed to obtain principal")
    public RuntimeException tokenRealmFailedToObtainPrincipal(@Cause Throwable var1);

    @Message(id=1105, value="OAuth2-based realm failed to introspect token")
    public RealmUnavailableException tokenRealmOAuth2TokenIntrospectionFailed(@Cause Throwable var1);

    @Message(id=1113, value="Token-based realm failed to obtain principal from token using claim [%s]")
    public IllegalStateException tokenRealmFailedToObtainPrincipalWithClaim(String var1);

    @Message(id=1114, value="Invalid token format. Tokens must have a signature part accordingly with JWS specification")
    public IllegalArgumentException tokenRealmJwtInvalidFormat();

    @Message(id=1115, value="Failed to parse token")
    public IllegalStateException tokenRealmJwtParseFailed(@Cause Throwable var1);

    @Message(id=1116, value="Signature verification failed")
    public IllegalStateException tokenRealmJwtSignatureCheckFailed(@Cause Throwable var1);

    @Message(id=1117, value="Invalid signature algorithm [%s]")
    public IllegalArgumentException tokenRealmJwtSignatureInvalidAlgorithm(String var1);

    @Message(id=1118, value="Public key could not be obtained. Probably due to an invalid PEM format.")
    public IllegalArgumentException tokenRealmJwtInvalidPublicKeyPem();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1126, value="Jwt-based token realm not configured with a list of valid issuers. Ignoring issuer verification.")
    public void tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1127, value="Jwt-based token not configured with a list of valid audiences. Ignoring audience verification.")
    public void tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1128, value="Jwt-based token not configured with a public key. Ignoring signature verification.")
    public void tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1178, value="Unable to update jwk set from \"%1$s\".")
    public void unableToFetchJwks(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1179, value="SSL not configured. jku claim will not be supported.")
    public void tokenRealmJwtNoSSLIgnoringJku();

    @LogMessage
    @Message(id=1180, value="Fetched jwk does not contain \"%1$s\" claim, ignoring...")
    public void tokenRealmJwkMissingClaim(String var1);
}

