/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.entity;

import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateParsingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.asn1.DERDecoder;
import org.wildfly.security.asn1.DEREncoder;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.callback.ServerCredentialCallback;
import org.wildfly.security.auth.callback.TrustedAuthoritiesCallback;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;
import org.wildfly.security.sasl.entity.Entity;
import org.wildfly.security.sasl.entity.EntityUtil;
import org.wildfly.security.sasl.util.AbstractSaslServer;
import org.wildfly.security.util.ByteStringBuilder;
import org.wildfly.security.x500.GeneralName;

final class EntitySaslServer
extends AbstractSaslServer {
    private static final int ST_CHALLENGE = 1;
    private static final int ST_PROCESS_RESPONSE = 2;
    private final SecureRandom secureRandom;
    private final Signature signature;
    private final boolean mutual;
    private final String serverName;
    private String authorizationID;
    private byte[] randomB;

    EntitySaslServer(String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler, boolean mutual, Signature signature, SecureRandom secureRandom) {
        super(mechanismName, protocol, serverName, callbackHandler);
        this.signature = signature;
        this.secureRandom = secureRandom;
        this.mutual = mutual;
        this.serverName = serverName;
    }

    @Override
    public void init() {
        this.setNegotiationState(1);
    }

    @Override
    public String getAuthorizationID() {
        if (!this.isComplete()) {
            throw ElytronMessages.log.mechAuthenticationNotComplete(this.getMechanismName());
        }
        return this.authorizationID;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected byte[] evaluateMessage(int state, byte[] response) throws SaslException {
        switch (state) {
            case 1: {
                if (response != null && response.length != 0) {
                    throw ElytronMessages.log.mechInitialChallengeMustBeEmpty(this.getMechanismName()).toSaslException();
                }
                tokenBA1 = new ByteStringBuilder();
                encoder = new DEREncoder(tokenBA1);
                try {
                    encoder.startSequence();
                    this.randomB = EntityUtil.encodeRandomNumber(encoder, this.secureRandom);
                    if (this.serverName != null && !this.serverName.isEmpty()) {
                        encoder.encodeImplicit(0);
                        EntityUtil.encodeGeneralNames(encoder, new GeneralName.DNSName(this.serverName));
                    }
                    trustedAuthoritiesCallback = new TrustedAuthoritiesCallback();
                    this.handleCallbacks(new Callback[]{trustedAuthoritiesCallback});
                    trustedAuthorities = trustedAuthoritiesCallback.getTrustedAuthorities();
                    if (trustedAuthorities != null && !trustedAuthorities.isEmpty()) {
                        encoder.encodeImplicit(1);
                        EntityUtil.encodeTrustedAuthorities(encoder, trustedAuthorities);
                    }
                    encoder.endSequence();
                }
                catch (ASN1Exception e) {
                    throw ElytronMessages.log.mechUnableToCreateResponseTokenWithCause(this.getMechanismName(), e).toSaslException();
                }
                this.setNegotiationState(2);
                return tokenBA1.toArray();
            }
            case 2: {
                decoder = new DERDecoder(response);
                serverCertChain = null;
                serverCert = null;
                serverCertUrl = null;
                privateKey = null;
                entityB = null;
                authID = null;
                try {
                    decoder.startSequence();
                    randomA = decoder.decodeOctetString();
                    if (decoder.isNextType(128, 0, true)) {
                        decoder.decodeImplicit(0);
                        entityB = EntityUtil.decodeGeneralNames(decoder);
                    }
                    decoder.startExplicit(1);
                    evidence = new X509PeerCertificateChainEvidence(EntityUtil.decodeCertificateData(decoder));
                    decoder.endExplicit();
                    clientCert = evidence.getFirstCertificate();
                    evidenceVerifyCallback = new EvidenceVerifyCallback(evidence);
                    this.handleCallbacks(new Callback[]{evidenceVerifyCallback});
                    if (!evidenceVerifyCallback.isVerified()) {
                        throw ElytronMessages.log.mechAuthenticationFailed(this.getMechanismName()).toSaslException();
                    }
                    clientName = evidence.getPrincipal().getName("CANONICAL");
                    if (decoder.isNextType(128, 2, true)) {
                        decoder.decodeImplicit(2);
                        authID = EntityUtil.decodeGeneralNames(decoder);
                        this.authorizationID = EntityUtil.getDistinguishedNameFromGeneralNames(authID);
                    } else {
                        this.authorizationID = clientName;
                    }
                    decoder.startSequence();
                    decoder.skipElement();
                    clientSignature = decoder.decodeBitString();
                    decoder.endSequence();
                    tbsDataAB = new ByteStringBuilder();
                    tbsEncoder = new DEREncoder(tbsDataAB);
                    tbsEncoder.startSequence();
                    tbsEncoder.encodeOctetString(randomA);
                    tbsEncoder.encodeOctetString(this.randomB);
                    if (entityB != null) {
                        tbsEncoder.encodeImplicit(0);
                        EntityUtil.encodeGeneralNames(tbsEncoder, entityB);
                    }
                    if (authID != null) {
                        tbsEncoder.encodeImplicit(1);
                        EntityUtil.encodeGeneralNames(tbsEncoder, authID);
                    }
                    tbsEncoder.endSequence();
                    try {
                        this.signature.initVerify(clientCert);
                        this.signature.update(tbsDataAB.toArray());
                        if (!this.signature.verify(clientSignature)) {
                            this.setNegotiationState(-1);
                            throw ElytronMessages.log.mechAuthenticationFailed(this.getMechanismName()).toSaslException();
                        }
                    }
                    catch (InvalidKeyException | SignatureException e) {
                        throw ElytronMessages.log.mechUnableToVerifyClientSignature(this.getMechanismName(), e).toSaslException();
                    }
                    decoder.endSequence();
                }
                catch (ASN1Exception e) {
                    throw ElytronMessages.log.mechInvalidClientMessageWithCause(this.getMechanismName(), e).toSaslException();
                }
                if (entityB != null || this.mutual) {
                    credentialCallback = new ServerCredentialCallback(X509CertificateChainPrivateCredential.class, Entity.keyType(this.signature.getAlgorithm()));
                    try {
                        this.tryHandleCallbacks(new Callback[]{credentialCallback});
                        serverCertChainPrivateCredential = credentialCallback.getCredential(X509CertificateChainPrivateCredential.class);
                        if (serverCertChainPrivateCredential != null) {
                            serverCertChain = serverCertChainPrivateCredential.getCertificateChain();
                            if (serverCertChain == null || serverCertChain.length <= 0) {
                                throw ElytronMessages.log.mechCallbackHandlerNotProvidedServerCertificate(this.getMechanismName()).toSaslException();
                            }
                            serverCert = serverCertChain[0];
                        } else {
                            throw ElytronMessages.log.mechCallbackHandlerNotProvidedServerCertificate(this.getMechanismName()).toSaslException();
                        }
                        privateKey = serverCertChainPrivateCredential.getPrivateKey();
                    }
                    catch (UnsupportedCallbackException e) {
                        throw ElytronMessages.log.mechCallbackHandlerNotProvidedServerCertificate(this.getMechanismName()).toSaslException();
                    }
                }
                if (entityB != null && !EntityUtil.matchGeneralNames(entityB, serverCert)) {
                    throw ElytronMessages.log.mechServerIdentifierMismatch(this.getMechanismName()).toSaslException();
                }
                authorizeCallback = new AuthorizeCallback(clientName, this.authorizationID);
                this.handleCallbacks(new Callback[]{authorizeCallback});
                if (!authorizeCallback.isAuthorized()) {
                    throw ElytronMessages.log.mechAuthorizationFailed(this.getMechanismName(), clientName, this.authorizationID).toSaslException();
                }
                if (!this.mutual) ** GOTO lbl156
                tokenBA2 = new ByteStringBuilder();
                encoder = new DEREncoder(tokenBA2);
                try {
                    encoder.startSequence();
                    randomC = EntityUtil.encodeRandomNumber(encoder, this.secureRandom);
                    clientSubjectAltNames = null;
                    try {
                        clientSubjectAltNames = clientCert.getSubjectAlternativeNames();
                    }
                    catch (CertificateParsingException e) {
                        if (!clientName.isEmpty()) ** GOTO lbl118
                        throw ElytronMessages.log.mechUnableToDetermineClientName(this.getMechanismName(), e).toSaslException();
                    }
lbl118:
                    // 2 sources

                    encoder.encodeImplicit(0);
                    EntityUtil.encodeGeneralNames(encoder, clientName, clientSubjectAltNames);
                    encoder.startExplicit(1);
                    if (serverCertChain != null && serverCertChain.length > 0) {
                        EntityUtil.encodeX509CertificateChain(encoder, serverCertChain);
                    } else if (serverCertUrl != null) {
                        encoder.encodeIA5String(serverCertUrl.toString());
                    } else {
                        throw ElytronMessages.log.mechCallbackHandlerNotProvidedServerCertificate(this.getMechanismName()).toSaslException();
                    }
                    encoder.endExplicit();
                    if (privateKey == null) {
                        throw ElytronMessages.log.mechCallbackHandlerNotProvidedPrivateKey(this.getMechanismName()).toSaslException();
                    }
                    tbsDataBA = new ByteStringBuilder();
                    tbsEncoder = new DEREncoder(tbsDataBA);
                    tbsEncoder.startSequence();
                    tbsEncoder.encodeOctetString(this.randomB);
                    tbsEncoder.encodeOctetString(randomA);
                    tbsEncoder.encodeOctetString(randomC);
                    EntityUtil.encodeGeneralNames(tbsEncoder, clientName, clientSubjectAltNames);
                    tbsEncoder.endSequence();
                    try {
                        this.signature.initSign(privateKey);
                        this.signature.update(tbsDataBA.toArray());
                        signatureBytes = this.signature.sign();
                    }
                    catch (InvalidKeyException | SignatureException e) {
                        throw ElytronMessages.log.mechUnableToCreateSignature(this.getMechanismName(), e).toSaslException();
                    }
                    encoder.startSequence();
                    EntityUtil.encodeAlgorithmIdentifier(encoder, this.signature.getAlgorithm());
                    encoder.encodeBitString(signatureBytes);
                    encoder.endSequence();
                    encoder.endSequence();
                }
                catch (ASN1Exception e) {
                    throw ElytronMessages.log.mechUnableToCreateResponseTokenWithCause(this.getMechanismName(), e).toSaslException();
                }
                this.negotiationComplete();
                return tokenBA2.toArray();
lbl156:
                // 1 sources

                this.negotiationComplete();
                return null;
            }
            case 0: {
                if (response != null && response.length != 0) {
                    throw ElytronMessages.log.mechClientSentExtraMessage(this.getMechanismName()).toSaslException();
                }
                return null;
            }
        }
        throw Assert.impossibleSwitchCase((int)state);
    }
}

