/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.credential.Credential;

public interface IdentityCredentials {
    public static final IdentityCredentials NONE = new IdentityCredentials(){

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) {
            return null;
        }

        @Override
        public IdentityCredentials with(IdentityCredentials other) {
            return other;
        }
    };

    default public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) {
        return this.getCredential(credentialType, algorithmName) != null ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    default public <C extends Credential> C getCredential(Class<C> credentialType) {
        return this.getCredential(credentialType, null);
    }

    public <C extends Credential> C getCredential(Class<C> var1, String var2);

    default public <C extends Credential, R> R applyToCredential(Class<C> credentialType, Function<C, R> function) throws RealmUnavailableException {
        C credential = this.getCredential(credentialType);
        return credential == null ? null : (R)credential.castAndApply(credentialType, function);
    }

    default public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, Function<C, R> function) throws RealmUnavailableException {
        C credential = this.getCredential(credentialType, algorithmName);
        return credential == null ? null : (R)credential.castAndApply(credentialType, algorithmName, function);
    }

    default public IdentityCredentials withCredential(final Credential credential) {
        Assert.checkNotNullParam((String)"credential", (Object)credential);
        return new IdentityCredentials(){

            @Override
            public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) {
                C result = credential.castAs(credentialType, algorithmName);
                return result != null ? result : IdentityCredentials.this.getCredential(credentialType, algorithmName);
            }
        };
    }

    default public IdentityCredentials with(final IdentityCredentials other) {
        Assert.checkNotNullParam((String)"other", (Object)other);
        return other == NONE ? this : new IdentityCredentials(){

            @Override
            public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) {
                C credential = IdentityCredentials.this.getCredential(credentialType, algorithmName);
                return credential != null ? credential : other.getCredential(credentialType, algorithmName);
            }
        };
    }
}

