/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.stream.XMLStreamReader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.client.config.ClientConfiguration;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.OneTimeSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.KeyStoreEntrySecurityFactory;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.auth.client.RuleConfigurationPair;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.util.ElytronAuthenticator;
import org.wildfly.security.auth.util.RegexNameRewriter;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.keystore.PasswordEntry;
import org.wildfly.security.keystore.WrappingPasswordKeyStore;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.util.ServiceLoaderSupplier;
import org.wildfly.security.x500.X500;

public final class ElytronXmlParser {
    private static final String NS_ELYTRON_1_0 = "urn:elytron:1.0";

    public static SecurityFactory<AuthenticationContext> parseAuthenticationClientConfiguration() throws ConfigXMLParseException {
        ClientConfiguration clientConfiguration = ClientConfiguration.getInstance();
        if (clientConfiguration != null) {
            try (ConfigurationXMLStreamReader streamReader = clientConfiguration.readConfiguration(Collections.singleton(NS_ELYTRON_1_0));){
                SecurityFactory<AuthenticationContext> securityFactory = ElytronXmlParser.parseAuthenticationClientConfiguration(streamReader);
                return securityFactory;
            }
        }
        return new FixedSecurityFactory<AuthenticationContext>(AuthenticationContext.EMPTY);
    }

    static SecurityFactory<AuthenticationContext> parseAuthenticationClientConfiguration(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    switch (reader.getNamespaceURI()) {
                        case "urn:elytron:1.0": {
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                    switch (reader.getLocalName()) {
                        case "authentication-client": {
                            SecurityFactory<AuthenticationContext> futureContext = ElytronXmlParser.parseAuthenticationClientType(reader);
                            block19: while (reader.hasNext()) {
                                switch (reader.next()) {
                                    case 3: 
                                    case 5: {
                                        continue block19;
                                    }
                                    case 8: {
                                        return futureContext;
                                    }
                                }
                                if (reader.isWhiteSpace()) continue;
                                throw reader.unexpectedElement();
                            }
                            return futureContext;
                        }
                    }
                    throw reader.unexpectedElement();
                }
            }
            throw reader.unexpectedContent();
        }
        return new FixedSecurityFactory<AuthenticationContext>(AuthenticationContext.EMPTY);
    }

    public static SecurityFactory<AuthenticationContext> parseAuthenticationClientType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        SecurityFactory<AuthenticationContext> futureContext = null;
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
        boolean rules = false;
        boolean keyStores = false;
        boolean netAuthenticator = false;
        HashMap<String, SecurityFactory<KeyStore>> keyStoresMap = new HashMap<String, SecurityFactory<KeyStore>>();
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                switch (reader.getNamespaceURI()) {
                    case "urn:elytron:1.0": {
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                switch (reader.getLocalName()) {
                    case "rules": {
                        if (rules) {
                            throw reader.unexpectedElement();
                        }
                        rules = true;
                        futureContext = ElytronXmlParser.parseAuthenticationClientRulesType(reader, keyStoresMap);
                        break;
                    }
                    case "key-stores": {
                        if (keyStores) {
                            throw reader.unexpectedElement();
                        }
                        keyStores = true;
                        ElytronXmlParser.parseKeyStoresType(reader, keyStoresMap);
                        break;
                    }
                    case "net-authenticator": {
                        if (netAuthenticator) {
                            throw reader.unexpectedElement();
                        }
                        netAuthenticator = true;
                        ElytronXmlParser.parseEmptyType(reader);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                if (netAuthenticator) {
                    Authenticator.setDefault(new ElytronAuthenticator());
                }
                return futureContext == null ? new FixedSecurityFactory<AuthenticationContext>(AuthenticationContext.EMPTY) : futureContext;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static SecurityFactory<AuthenticationContext> parseAuthenticationClientRulesType(ConfigurationXMLStreamReader reader, Map<String, SecurityFactory<KeyStore>> keyStoresMap) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
        HashMap<String, SecurityFactory<RuleConfigurationPair>> rulesMap = new HashMap<String, SecurityFactory<RuleConfigurationPair>>();
        ArrayList<SecurityFactory<RuleConfigurationPair>> rulesList = new ArrayList<SecurityFactory<RuleConfigurationPair>>();
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                switch (reader.getNamespaceURI()) {
                    case "urn:elytron:1.0": {
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                switch (reader.getLocalName()) {
                    case "rule": {
                        ElytronXmlParser.parseAuthenticationClientRuleType(reader, rulesList, rulesMap, keyStoresMap);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                return new OneTimeSecurityFactory<AuthenticationContext>(() -> {
                    AuthenticationContext context = AuthenticationContext.EMPTY;
                    for (SecurityFactory pairFactory : rulesList) {
                        RuleConfigurationPair pair = (RuleConfigurationPair)pairFactory.create();
                        context = context.with(pair.getMatchRule(), pair.getConfiguration());
                    }
                    return context;
                });
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static void parseAuthenticationClientRuleType(ConfigurationXMLStreamReader reader, List<SecurityFactory<RuleConfigurationPair>> rulesList, Map<String, SecurityFactory<RuleConfigurationPair>> rulesMap, Map<String, SecurityFactory<KeyStore>> keyStoresMap) throws ConfigXMLParseException {
        SecurityFactory<AuthenticationConfiguration> configuration;
        SecurityFactory<MatchRule> rule;
        int attributeCount = reader.getAttributeCount();
        String name = null;
        String _extends = null;
        block70: for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            switch (reader.getAttributeLocalName(i)) {
                case "extends": {
                    if (_extends != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    _extends = reader.getAttributeValue(i);
                    continue block70;
                }
                case "name": {
                    if (name != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    name = reader.getAttributeValue(i);
                    continue block70;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (_extends == null) {
            rule = new FixedSecurityFactory<MatchRule>(MatchRule.ALL);
            configuration = new FixedSecurityFactory<AuthenticationConfiguration>(AuthenticationConfiguration.EMPTY);
        } else {
            String ext = _extends;
            rule = () -> {
                SecurityFactory factory = (SecurityFactory)rulesMap.get(ext);
                if (factory == null) {
                    throw ElytronMessages.log.missingReferenceInExtends();
                }
                return ((RuleConfigurationPair)factory.create()).getMatchRule();
            };
            configuration = () -> {
                SecurityFactory factory = (SecurityFactory)rulesMap.get(ext);
                if (factory == null) {
                    throw ElytronMessages.log.missingReferenceInExtends();
                }
                return ((RuleConfigurationPair)factory.create()).getConfiguration();
            };
        }
        boolean gotConfig = false;
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                switch (reader.getNamespaceURI()) {
                    case "urn:elytron:1.0": {
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                switch (reader.getLocalName()) {
                    case "match-no-userinfo": {
                        if (gotConfig) {
                            throw reader.unexpectedElement();
                        }
                        ElytronXmlParser.parseEmptyType(reader);
                        SecurityFactory<MatchRule> parentRule = rule;
                        rule = () -> ((MatchRule)parentRule.create()).matchNoUser();
                        break;
                    }
                    case "match-userinfo": {
                        if (gotConfig) {
                            throw reader.unexpectedElement();
                        }
                        String userName = ElytronXmlParser.parseNameType(reader);
                        SecurityFactory<MatchRule> parentRule = rule;
                        rule = () -> ((MatchRule)parentRule.create()).matchUser(userName);
                        break;
                    }
                    case "match-protocol": {
                        if (gotConfig) {
                            throw reader.unexpectedElement();
                        }
                        String protoName = ElytronXmlParser.parseNameType(reader);
                        SecurityFactory<MatchRule> parentRule = rule;
                        rule = () -> ((MatchRule)parentRule.create()).matchProtocol(protoName);
                        break;
                    }
                    case "match-host": {
                        if (gotConfig) {
                            throw reader.unexpectedElement();
                        }
                        String hostName = ElytronXmlParser.parseNameType(reader);
                        SecurityFactory<MatchRule> parentRule = rule;
                        rule = () -> ((MatchRule)parentRule.create()).matchHost(hostName);
                        break;
                    }
                    case "match-path": {
                        if (gotConfig) {
                            throw reader.unexpectedElement();
                        }
                        String pathName = ElytronXmlParser.parseNameType(reader);
                        SecurityFactory<MatchRule> parentRule = rule;
                        rule = () -> ((MatchRule)parentRule.create()).matchPath(pathName);
                        break;
                    }
                    case "match-port": {
                        if (gotConfig) {
                            throw reader.unexpectedElement();
                        }
                        int port = ElytronXmlParser.parsePortType(reader);
                        SecurityFactory<MatchRule> parentRule = rule;
                        rule = () -> ((MatchRule)parentRule.create()).matchPort(port);
                        break;
                    }
                    case "match-urn": {
                        if (gotConfig) {
                            throw reader.unexpectedElement();
                        }
                        String urnString = ElytronXmlParser.parseNameType(reader);
                        SecurityFactory<MatchRule> parentRule = rule;
                        rule = () -> ((MatchRule)parentRule.create()).matchUrnName(urnString);
                        break;
                    }
                    case "match-domain": {
                        if (gotConfig) {
                            throw reader.unexpectedElement();
                        }
                        String domainName = ElytronXmlParser.parseNameType(reader);
                        SecurityFactory<MatchRule> parentRule = rule;
                        rule = () -> ((MatchRule)parentRule.create()).matchLocalSecurityDomain(domainName);
                        break;
                    }
                    case "set-host": {
                        gotConfig = true;
                        String hostName = ElytronXmlParser.parseNameType(reader);
                        SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = () -> ((AuthenticationConfiguration)parentConfig.create()).useHost(hostName);
                        break;
                    }
                    case "set-port": {
                        gotConfig = true;
                        int port = ElytronXmlParser.parsePortType(reader);
                        SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = () -> ((AuthenticationConfiguration)parentConfig.create()).usePort(port);
                        break;
                    }
                    case "set-user-name": {
                        gotConfig = true;
                        String userName = ElytronXmlParser.parseNameType(reader);
                        SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = () -> ((AuthenticationConfiguration)parentConfig.create()).useName(userName);
                        break;
                    }
                    case "set-anonymous": {
                        gotConfig = true;
                        ElytronXmlParser.parseEmptyType(reader);
                        SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = () -> ((AuthenticationConfiguration)parentConfig.create()).useAnonymous();
                        break;
                    }
                    case "set-mechanism-realm": {
                        gotConfig = true;
                        String realm = ElytronXmlParser.parseNameType(reader);
                        SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = () -> ((AuthenticationConfiguration)parentConfig.create()).useRealm(realm);
                        break;
                    }
                    case "rewrite-user-name-regex": {
                        gotConfig = true;
                        NameRewriter nameRewriter = ElytronXmlParser.parseRegexSubstitutionType(reader);
                        SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = () -> ((AuthenticationConfiguration)parentConfig.create()).rewriteUser(nameRewriter);
                        break;
                    }
                    case "set-mechanism-properties": {
                        gotConfig = true;
                        Map<String, String> mechanismProperties = ElytronXmlParser.parsePropertiesType(reader);
                        SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = () -> ((AuthenticationConfiguration)parentConfig.create()).useMechanismProperties(mechanismProperties);
                        break;
                    }
                    case "allow-all-sasl-mechanisms": {
                        gotConfig = true;
                        ElytronXmlParser.parseEmptyType(reader);
                        SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = () -> ((AuthenticationConfiguration)parentConfig.create()).allowAllSaslMechanisms();
                        break;
                    }
                    case "allow-sasl-mechanisms": {
                        gotConfig = true;
                        String[] names = ElytronXmlParser.parseNamesType(reader);
                        SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = () -> ((AuthenticationConfiguration)parentConfig.create()).allowSaslMechanisms(names);
                        break;
                    }
                    case "forbid-sasl-mechanisms": {
                        gotConfig = true;
                        String[] names = ElytronXmlParser.parseNamesType(reader);
                        SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = () -> ((AuthenticationConfiguration)parentConfig.create()).forbidSaslMechanisms(names);
                        break;
                    }
                    case "key-store-credential": {
                        gotConfig = true;
                        SecurityFactory<KeyStore.Entry> factory = ElytronXmlParser.parseKeyStoreRefType(reader, keyStoresMap);
                        SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = () -> ((AuthenticationConfiguration)parentConfig.create()).useKeyStoreCredential((KeyStore.Entry)factory.create());
                        break;
                    }
                    case "clear-password": {
                        gotConfig = true;
                        SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        char[] password = ElytronXmlParser.parseClearPassword(reader);
                        configuration = () -> ((AuthenticationConfiguration)parentConfig.create()).usePassword(ClearPassword.createRaw("clear", password));
                        break;
                    }
                    case "set-authorization-name": {
                        gotConfig = true;
                        String authName = ElytronXmlParser.parseNameType(reader);
                        SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = () -> ((AuthenticationConfiguration)parentConfig.create()).useAuthorizationName(authName);
                        break;
                    }
                    case "key-store-ssl-certificate": {
                        gotConfig = true;
                        SecurityFactory<KeyStore.Entry> factory = ElytronXmlParser.parseKeyStoreRefType(reader, keyStoresMap);
                        SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = () -> ((AuthenticationConfiguration)parentConfig.create()).useSslClientCredential(new PrivateKeyKeyStoreEntryCredentialFactory(factory));
                        break;
                    }
                    case "ssl-cipher-suite": {
                        gotConfig = true;
                        CipherSuiteSelector selector = ElytronXmlParser.parseCipherSuiteSelectorType(reader);
                        SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = () -> ((AuthenticationConfiguration)parentConfig.create()).useSslCipherSuiteSelector(selector);
                        break;
                    }
                    case "ssl-protocol": {
                        gotConfig = true;
                        ProtocolSelector selector = ElytronXmlParser.parseProtocolSelectorNamesType(reader);
                        SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = () -> ((AuthenticationConfiguration)parentConfig.create()).useSslProtocolSelector(selector);
                        break;
                    }
                    case "use-system-providers": {
                        gotConfig = true;
                        SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        configuration = () -> ((AuthenticationConfiguration)parentConfig.create()).useProviders(null);
                        break;
                    }
                    case "use-module-providers": {
                        gotConfig = true;
                        SecurityFactory<AuthenticationConfiguration> parentConfig = configuration;
                        Module module = ElytronXmlParser.parseModuleRefType(reader);
                        configuration = () -> ((AuthenticationConfiguration)parentConfig.create()).useProviders(new ServiceLoaderSupplier<Provider>(Provider.class, (ClassLoader)module.getClassLoader()));
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                OneTimeSecurityFactory<MatchRule> finalRule = new OneTimeSecurityFactory<MatchRule>(rule);
                OneTimeSecurityFactory<AuthenticationConfiguration> finalConfig = new OneTimeSecurityFactory<AuthenticationConfiguration>(configuration);
                SecurityFactory<RuleConfigurationPair> finalPair = () -> new RuleConfigurationPair((MatchRule)finalRule.create(), (AuthenticationConfiguration)finalConfig.create());
                rulesList.add(finalPair);
                if (name != null) {
                    rulesMap.put(name, finalPair);
                }
                return;
            }
            throw reader.unexpectedContent();
        }
    }

    public static void parseKeyStoresType(ConfigurationXMLStreamReader reader, Map<String, SecurityFactory<KeyStore>> keyStoresMap) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                switch (reader.getNamespaceURI()) {
                    case "urn:elytron:1.0": {
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                switch (reader.getLocalName()) {
                    case "key-store": {
                        ElytronXmlParser.parseKeyStoreType(reader, keyStoresMap);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static void parseKeyStoreType(ConfigurationXMLStreamReader reader, Map<String, SecurityFactory<KeyStore>> keyStoresMap) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String name = null;
        String type = null;
        String provider = null;
        Boolean wrap = null;
        block32: for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            switch (reader.getAttributeLocalName(i)) {
                case "type": {
                    if (type != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    type = reader.getAttributeValue(i);
                    continue block32;
                }
                case "provider": {
                    if (provider != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    provider = reader.getAttributeValue(i);
                    continue block32;
                }
                case "name": {
                    if (name != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    name = reader.getAttributeValue(i);
                    continue block32;
                }
                case "wrap-passwords": {
                    if (wrap != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    wrap = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block32;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (type == null) {
            throw ElytronXmlParser.missingAttribute(reader, "type");
        }
        if (name == null) {
            throw ElytronXmlParser.missingAttribute(reader, "name");
        }
        SecurityFactory<char[]> passwordFactory = null;
        boolean gotSource = false;
        boolean gotCredential = false;
        String fileSource = null;
        String resourceSource = null;
        URI uriSource = null;
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                switch (reader.getNamespaceURI()) {
                    case "urn:elytron:1.0": {
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                switch (reader.getLocalName()) {
                    case "key-store-credential": {
                        if (!gotSource || gotCredential) {
                            throw reader.unexpectedElement();
                        }
                        gotCredential = true;
                        SecurityFactory<KeyStore.Entry> entryFactory = ElytronXmlParser.parseKeyStoreRefType(reader, keyStoresMap);
                        passwordFactory = new OneTimeSecurityFactory<char[]>(() -> {
                            KeyStore.Entry entry = (KeyStore.Entry)entryFactory.create();
                            if (entry instanceof PasswordEntry) {
                                Password password = ((PasswordEntry)entry).getPassword();
                                PasswordFactory passwordFactory1 = PasswordFactory.getInstance(password.getAlgorithm());
                                ClearPasswordSpec passwordSpec = passwordFactory1.getKeySpec(password, ClearPasswordSpec.class);
                                return passwordSpec.getEncodedPassword();
                            }
                            return null;
                        });
                        break;
                    }
                    case "key-store-clear-password": {
                        if (!gotSource || gotCredential) {
                            throw reader.unexpectedElement();
                        }
                        gotCredential = true;
                        passwordFactory = new FixedSecurityFactory<char[]>(ElytronXmlParser.parseClearPassword(reader));
                        break;
                    }
                    case "file": {
                        if (gotSource) {
                            throw reader.unexpectedElement();
                        }
                        gotSource = true;
                        fileSource = ElytronXmlParser.parseNameType(reader);
                        break;
                    }
                    case "resource": {
                        if (gotSource) {
                            throw reader.unexpectedElement();
                        }
                        gotSource = true;
                        resourceSource = ElytronXmlParser.parseNameType(reader);
                        break;
                    }
                    case "uri": {
                        if (gotSource) {
                            throw reader.unexpectedElement();
                        }
                        gotSource = true;
                        uriSource = ElytronXmlParser.parseUriType(reader);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                SecurityFactory<KeyStore> keyStoreFactory = new KeyStoreCreateFactory(provider, type);
                if (wrap == Boolean.TRUE) {
                    keyStoreFactory = new PasswordKeyStoreFactory(keyStoreFactory);
                }
                if (fileSource != null) {
                    keyStoreFactory = new FileLoadingKeyStoreFactory(keyStoreFactory, passwordFactory, fileSource);
                } else if (resourceSource != null) {
                    keyStoreFactory = new ResourceLoadingKeyStoreFactory(keyStoreFactory, passwordFactory, resourceSource);
                } else if (uriSource != null) {
                    keyStoreFactory = new URILoadingKeyStoreFactory(keyStoreFactory, passwordFactory, uriSource);
                } else {
                    throw new IllegalStateException();
                }
                keyStoresMap.put(name, new OneTimeSecurityFactory<KeyStore>(keyStoreFactory));
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static SecurityFactory<KeyStore.Entry> parseKeyStoreRefType(ConfigurationXMLStreamReader reader, Map<String, SecurityFactory<KeyStore>> keyStoresMap) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String keyStoreName = null;
        String alias = null;
        block22: for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            switch (reader.getAttributeLocalName(i)) {
                case "key-store-name": {
                    if (keyStoreName != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    keyStoreName = reader.getAttributeValue(i);
                    continue block22;
                }
                case "alias": {
                    if (alias != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    alias = reader.getAttributeValue(i);
                    continue block22;
                }
            }
        }
        if (keyStoreName == null) {
            throw ElytronXmlParser.missingAttribute(reader, "key-store-name");
        }
        if (alias == null) {
            throw ElytronXmlParser.missingAttribute(reader, "alias");
        }
        SecurityFactory<KeyStore.Entry> keyStoreCredential = null;
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                switch (reader.getNamespaceURI()) {
                    case "urn:elytron:1.0": {
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                switch (reader.getLocalName()) {
                    case "key-store-credential": {
                        if (keyStoreCredential != null) {
                            throw reader.unexpectedElement();
                        }
                        keyStoreCredential = ElytronXmlParser.parseKeyStoreRefType(reader, keyStoresMap);
                        break;
                    }
                    case "key-store-clear-password": {
                        if (keyStoreCredential != null) {
                            throw reader.unexpectedElement();
                        }
                        keyStoreCredential = new FixedSecurityFactory<PasswordEntry>(new PasswordEntry(ClearPassword.createRaw("clear", ElytronXmlParser.parseClearPassword(reader))));
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                SecurityFactory<KeyStore.Entry> finalKeyStoreCredential = keyStoreCredential;
                String finalKeyStoreName = keyStoreName;
                return new KeyStoreEntrySecurityFactory(() -> {
                    SecurityFactory keyStoreSecurityFactory = (SecurityFactory)keyStoresMap.get(finalKeyStoreName);
                    if (keyStoreSecurityFactory == null) {
                        throw ElytronMessages.log.unknownKeyStoreSpecified();
                    }
                    return (KeyStore)keyStoreSecurityFactory.create();
                }, alias, keyStoreCredential == null ? null : () -> {
                    KeyStore.Entry entry = (KeyStore.Entry)finalKeyStoreCredential.create();
                    if (entry instanceof PasswordEntry) {
                        Password password = ((PasswordEntry)entry).getPassword();
                        PasswordFactory passwordFactory = PasswordFactory.getInstance(password.getAlgorithm());
                        ClearPasswordSpec spec = passwordFactory.getKeySpec(password, ClearPasswordSpec.class);
                        return new KeyStore.PasswordProtection(spec.getEncodedPassword());
                    }
                    if (entry instanceof KeyStore.SecretKeyEntry) {
                        SecretKey secretKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
                        SecretKeyFactory instance = SecretKeyFactory.getInstance(secretKey.getAlgorithm());
                        SecretKeySpec keySpec = (SecretKeySpec)instance.getKeySpec(secretKey, SecretKeySpec.class);
                        byte[] encoded = keySpec.getEncoded();
                        return encoded == null ? null : new KeyStore.PasswordProtection(new String(encoded, StandardCharsets.UTF_8).toCharArray());
                    }
                    return null;
                });
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static void parseEmptyType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static String parseNameType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String name = null;
        for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            if (!reader.getAttributeLocalName(i).equals("name")) {
                throw reader.unexpectedAttribute(i);
            }
            name = reader.getAttributeValue(i);
        }
        if (name == null) {
            throw ElytronXmlParser.missingAttribute(reader, "name");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return name;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static int parsePortType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        int number = -1;
        for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            if (reader.getAttributeLocalName(i).equals("number")) {
                String s = reader.getAttributeValue(i);
                try {
                    number = Integer.parseInt(s);
                }
                catch (NumberFormatException ignored) {
                    throw ElytronXmlParser.invalidPortNumber(reader, i);
                }
                if (number >= 1 && number <= 65535) continue;
                throw ElytronXmlParser.invalidPortNumber(reader, i);
            }
            throw reader.unexpectedAttribute(i);
        }
        if (number == -1) {
            throw ElytronXmlParser.missingAttribute(reader, "number");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return number;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static NameRewriter parseRegexSubstitutionType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        Pattern pattern = null;
        String replacement = null;
        for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            if (reader.getAttributeLocalName(i).equals("pattern")) {
                pattern = Pattern.compile(reader.getAttributeValue(i));
                continue;
            }
            if (reader.getAttributeLocalName(i).equals("replacement")) {
                replacement = reader.getAttributeValue(i);
                continue;
            }
            throw reader.unexpectedAttribute(i);
        }
        if (pattern == null) {
            throw ElytronXmlParser.missingAttribute(reader, "pattern");
        }
        if (replacement == null) {
            throw ElytronXmlParser.missingAttribute(reader, "replacement");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return new RegexNameRewriter(pattern, replacement, true);
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static String[] parseNamesType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String[] names = null;
        for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            if (!reader.getAttributeLocalName(i).equals("names")) {
                throw reader.unexpectedAttribute(i);
            }
            String s = reader.getAttributeValue(i);
            names = s.trim().split("\\s+");
        }
        if (names == null) {
            throw ElytronXmlParser.missingAttribute(reader, "names");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return names;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static URI parseUriType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        URI uri = null;
        for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            if (!reader.getAttributeLocalName(i).equals("uri")) {
                throw reader.unexpectedAttribute(i);
            }
            uri = reader.getURIAttributeValue(i);
        }
        if (uri == null) {
            throw ElytronXmlParser.missingAttribute(reader, "uri");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return uri;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static CipherSuiteSelector parseCipherSuiteSelectorType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        CipherSuiteSelector selector = null;
        for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            if (!reader.getAttributeLocalName(i).equals("selector")) {
                throw reader.unexpectedAttribute(i);
            }
            selector = CipherSuiteSelector.fromString(reader.getAttributeValue(i));
        }
        if (selector == null) {
            throw ElytronXmlParser.missingAttribute(reader, "selector");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return selector;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static ProtocolSelector parseProtocolSelectorNamesType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        ProtocolSelector selector = ProtocolSelector.empty();
        for (String name : ElytronXmlParser.parseNamesType(reader)) {
            selector = selector.add(name);
        }
        return selector;
    }

    public static Module parseModuleRefType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String name = null;
        String slot = null;
        for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            if (reader.getAttributeLocalName(i).equals("name")) {
                name = reader.getAttributeValue(i);
                continue;
            }
            if (reader.getAttributeLocalName(i).equals("slot")) {
                slot = reader.getAttributeValue(i);
                continue;
            }
            throw reader.unexpectedAttribute(i);
        }
        if (name == null) {
            throw ElytronXmlParser.missingAttribute(reader, "name");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                ModuleIdentifier identifier = ModuleIdentifier.create((String)name, slot);
                try {
                    return Module.getModuleFromCallerModuleLoader((ModuleIdentifier)identifier);
                }
                catch (ModuleLoadException e) {
                    throw ElytronMessages.log.noModuleFound((XMLStreamReader)reader, e, identifier);
                }
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static char[] parseClearPassword(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        char[] password = null;
        for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            if (!reader.getAttributeLocalName(i).equals("password")) {
                throw reader.unexpectedAttribute(i);
            }
            password = reader.getAttributeValue(i).toCharArray();
        }
        if (password == null) {
            throw ElytronXmlParser.missingAttribute(reader, "password");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return password;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    public static Map<String, String> parsePropertiesType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        if (reader.getAttributeCount() > 0) {
            throw reader.unexpectedAttribute(0);
        }
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                switch (reader.getNamespaceURI()) {
                    case "urn:elytron:1.0": {
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                switch (reader.getLocalName()) {
                    case "property": {
                        int attributeCount = reader.getAttributeCount();
                        String key = null;
                        String value = null;
                        block21: for (int i = 0; i < attributeCount; ++i) {
                            String attributeNamespace = reader.getAttributeNamespace(i);
                            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                                throw reader.unexpectedAttribute(i);
                            }
                            switch (reader.getAttributeLocalName(i)) {
                                case "key": {
                                    if (key != null) {
                                        throw reader.unexpectedAttribute(i);
                                    }
                                    key = reader.getAttributeValue(i);
                                    continue block21;
                                }
                                case "value": {
                                    if (value != null) {
                                        throw reader.unexpectedAttribute(i);
                                    }
                                    value = reader.getAttributeValue(i);
                                    continue block21;
                                }
                                default: {
                                    throw reader.unexpectedAttribute(i);
                                }
                            }
                        }
                        if (key == null) {
                            throw ElytronXmlParser.missingAttribute(reader, "key");
                        }
                        if (value == null) {
                            throw ElytronXmlParser.missingAttribute(reader, "value");
                        }
                        propertiesMap.put(key, value);
                        if (reader.hasNext()) {
                            int innerTag = reader.nextTag();
                            if (innerTag == 1) {
                                throw reader.unexpectedElement();
                            }
                            if (innerTag == 2) break;
                            throw reader.unexpectedContent();
                        }
                        throw reader.unexpectedDocumentEnd();
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                return propertiesMap;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static ConfigXMLParseException missingAttribute(ConfigurationXMLStreamReader reader, String name) {
        return reader.missingRequiredAttribute(null, name);
    }

    private static ConfigXMLParseException invalidPortNumber(ConfigurationXMLStreamReader reader, int index) {
        return ElytronMessages.xmlLog.xmlInvalidPortNumber((XMLStreamReader)reader, reader.getAttributeValue(index), reader.getAttributeLocalName(index), reader.getName());
    }

    static final class PrivateKeyKeyStoreEntryCredentialFactory
    implements SecurityFactory<X509CertificateChainPrivateCredential> {
        private final SecurityFactory<KeyStore.Entry> entrySecurityFactory;

        PrivateKeyKeyStoreEntryCredentialFactory(SecurityFactory<KeyStore.Entry> entrySecurityFactory) {
            this.entrySecurityFactory = entrySecurityFactory;
        }

        @Override
        public X509CertificateChainPrivateCredential create() throws GeneralSecurityException {
            KeyStore.Entry entry = this.entrySecurityFactory.create();
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                X509Certificate[] certificateChain = X500.asX509CertificateArray(privateKeyEntry.getCertificateChain());
                return new X509CertificateChainPrivateCredential(privateKeyEntry.getPrivateKey(), certificateChain);
            }
            throw ElytronMessages.log.invalidKeyStoreEntryType("unknown", KeyStore.PrivateKeyEntry.class, entry.getClass());
        }
    }

    static final class URILoadingKeyStoreFactory
    extends AbstractLoadingKeyStoreFactory {
        private final URI uri;

        URILoadingKeyStoreFactory(SecurityFactory<KeyStore> delegateFactory, SecurityFactory<char[]> passwordFactory, URI uri) {
            super(delegateFactory, passwordFactory);
            this.uri = uri;
        }

        @Override
        InputStream createStream() throws IOException {
            return this.uri.toURL().openStream();
        }
    }

    static final class ResourceLoadingKeyStoreFactory
    extends AbstractLoadingKeyStoreFactory {
        private final String resourceName;

        ResourceLoadingKeyStoreFactory(SecurityFactory<KeyStore> delegateFactory, SecurityFactory<char[]> passwordFactory, String resourceName) {
            super(delegateFactory, passwordFactory);
            this.resourceName = resourceName;
        }

        @Override
        InputStream createStream() throws IOException {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            InputStream stream = contextClassLoader.getResourceAsStream(this.resourceName);
            if (stream == null) {
                throw new FileNotFoundException(this.resourceName);
            }
            return stream;
        }
    }

    static final class FileLoadingKeyStoreFactory
    extends AbstractLoadingKeyStoreFactory {
        private final String fileName;

        FileLoadingKeyStoreFactory(SecurityFactory<KeyStore> delegateFactory, SecurityFactory<char[]> passwordFactory, String fileName) {
            super(delegateFactory, passwordFactory);
            this.fileName = fileName;
        }

        @Override
        InputStream createStream() throws FileNotFoundException {
            return new FileInputStream(this.fileName);
        }
    }

    static abstract class AbstractLoadingKeyStoreFactory
    implements SecurityFactory<KeyStore> {
        protected final SecurityFactory<KeyStore> delegateFactory;
        protected final SecurityFactory<char[]> passwordFactory;

        protected AbstractLoadingKeyStoreFactory(SecurityFactory<KeyStore> delegateFactory, SecurityFactory<char[]> passwordFactory) {
            this.delegateFactory = delegateFactory;
            this.passwordFactory = passwordFactory;
        }

        @Override
        public KeyStore create() throws GeneralSecurityException {
            KeyStore keyStore = this.delegateFactory.create();
            try (InputStream fis = this.createStream();){
                keyStore.load(fis, this.passwordFactory == null ? null : this.passwordFactory.create());
            }
            catch (IOException e) {
                throw ElytronMessages.log.failedToLoadKeyStoreData(e);
            }
            return keyStore;
        }

        abstract InputStream createStream() throws IOException;
    }

    static final class PasswordKeyStoreFactory
    implements SecurityFactory<KeyStore> {
        private final SecurityFactory<KeyStore> delegateFactory;

        PasswordKeyStoreFactory(SecurityFactory<KeyStore> delegateFactory) {
            this.delegateFactory = delegateFactory;
        }

        @Override
        public KeyStore create() throws GeneralSecurityException {
            return new WrappingPasswordKeyStore(this.delegateFactory.create());
        }
    }

    static final class KeyStoreCreateFactory
    implements SecurityFactory<KeyStore> {
        private final String provider;
        private final String type;

        KeyStoreCreateFactory(String provider, String type) {
            this.provider = provider;
            this.type = type;
        }

        @Override
        public KeyStore create() throws GeneralSecurityException {
            return this.provider == null ? KeyStore.getInstance(this.type) : KeyStore.getInstance(this.type, this.provider);
        }
    }
}

