/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.security.KeyStore;
import java.security.KeyStoreSpi;
import java.security.Provider;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.keystore.LdapKeyStoreSpi;

public class LdapKeyStore
extends KeyStore {
    protected LdapKeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String type) {
        super(keyStoreSpi, provider, type);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ExceptionSupplier<DirContext, NamingException> dirContextSupplier;
        private String searchPath;
        private String filterAlias;
        private String filterCertificate;
        private String filterIterate;
        private LdapName createPath;
        private String createRdn = "cn";
        private Attributes createAttributes;
        private String aliasAttribute = "cn";
        private String certificateAttribute = "usercertificate";
        private String certificateType = "X.509";
        private String certificateChainAttribute = "userSMIMECertificate";
        private String certificateChainType = "X.509";
        private String certificateChainEncoding = "PKCS7";
        private String keyAttribute = "userPKCS12";
        private String keyType = "PKCS12";

        private Builder() {
        }

        public LdapKeyStore build() {
            Assert.assertNotNull(this.dirContextSupplier);
            Assert.assertNotNull((Object)this.searchPath);
            Assert.assertNotNull((Object)this.filterAlias);
            Assert.assertNotNull((Object)this.filterCertificate);
            Assert.assertNotNull((Object)this.filterIterate);
            Assert.assertNotNull((Object)this.aliasAttribute);
            Assert.assertNotNull((Object)this.certificateAttribute);
            Assert.assertNotNull((Object)this.certificateType);
            Assert.assertNotNull((Object)this.certificateChainAttribute);
            Assert.assertNotNull((Object)this.certificateChainType);
            Assert.assertNotNull((Object)this.certificateChainEncoding);
            Assert.assertNotNull((Object)this.keyAttribute);
            Assert.assertNotNull((Object)this.keyType);
            LdapKeyStoreSpi spi = new LdapKeyStoreSpi(this.dirContextSupplier, this.searchPath, this.filterAlias, this.filterCertificate, this.filterIterate, this.createPath, this.createRdn, this.createAttributes, this.aliasAttribute, this.certificateAttribute, this.certificateType, this.certificateChainAttribute, this.certificateChainType, this.certificateChainEncoding, this.keyAttribute, this.keyType);
            return new LdapKeyStore(spi, null, null);
        }

        public Builder setDirContextSupplier(ExceptionSupplier<DirContext, NamingException> dirContextSupplier) {
            this.dirContextSupplier = dirContextSupplier;
            return this;
        }

        public Builder setSearchPath(String searchPath) {
            this.searchPath = searchPath;
            return this;
        }

        public Builder setFilterAlias(String filterAlias) {
            this.filterAlias = filterAlias;
            return this;
        }

        public Builder setFilterCertificate(String filterCertificate) {
            this.filterCertificate = filterCertificate;
            return this;
        }

        public Builder setFilterIterate(String filterIterate) {
            this.filterIterate = filterIterate;
            return this;
        }

        public Builder setCreatePath(LdapName createPath) {
            this.createPath = createPath;
            return this;
        }

        public Builder setCreateRdn(String createRdn) {
            this.createRdn = createRdn;
            return this;
        }

        public Builder setCreateAttributes(Attributes createAttributes) {
            this.createAttributes = createAttributes;
            return this;
        }

        public Builder setAliasAttribute(String aliasAttribute) {
            this.aliasAttribute = aliasAttribute;
            return this;
        }

        public Builder setCertificateAttribute(String certificateAttribute) {
            this.certificateAttribute = certificateAttribute;
            return this;
        }

        public Builder setCertificateType(String certificateType) {
            this.certificateType = certificateType;
            return this;
        }

        public Builder setCertificateChainAttribute(String certificateChainAttribute) {
            this.certificateChainAttribute = certificateChainAttribute;
            return this;
        }

        public Builder setCertificateChainType(String certificateChainType) {
            this.certificateChainType = certificateChainType;
            return this;
        }

        public Builder setCertificateChainEncoding(String certificateChainEncoding) {
            this.certificateChainEncoding = certificateChainEncoding;
            return this;
        }

        public Builder setKeyAttribute(String keyAttribute) {
            this.keyAttribute = keyAttribute;
            return this;
        }

        public Builder setKeyType(String keyType) {
            this.keyType = keyType;
            return this;
        }
    }
}

