/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.ParametricPrivilegedExceptionAction;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.client.PeerIdentity;
import org.wildfly.security.auth.permission.ChangeRoleMapperPermission;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.RealmInfo;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.PermissionMappable;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.permission.ElytronPermission;
import org.wildfly.security.permission.PermissionVerifier;

public final class SecurityIdentity
implements PermissionVerifier,
PermissionMappable {
    static final PeerIdentity[] NO_PEER_IDENTITIES = new PeerIdentity[0];
    private static final Permission SET_RUN_AS_PERMISSION = ElytronPermission.forName("setRunAsPrincipal");
    private final SecurityDomain securityDomain;
    private final Principal principal;
    private final AuthorizationIdentity authorizationIdentity;
    private final RealmInfo realmInfo;
    private final Map<String, RoleMapper> roleMappers;
    private final PeerIdentity[] peerIdentities;
    private final Instant creationTime;
    private final PermissionVerifier verifier;

    SecurityIdentity(SecurityDomain securityDomain, Principal principal, RealmInfo realmInfo, AuthorizationIdentity authorizationIdentity, Map<String, RoleMapper> roleMappers) {
        this(securityDomain, principal, realmInfo, authorizationIdentity, roleMappers, NO_PEER_IDENTITIES);
    }

    SecurityIdentity(SecurityDomain securityDomain, Principal principal, RealmInfo realmInfo, AuthorizationIdentity authorizationIdentity, Map<String, RoleMapper> roleMappers, PeerIdentity[] peerIdentities) {
        this.securityDomain = securityDomain;
        this.principal = principal;
        this.realmInfo = realmInfo;
        this.authorizationIdentity = authorizationIdentity;
        this.roleMappers = roleMappers;
        this.peerIdentities = peerIdentities;
        this.creationTime = Instant.now();
        this.verifier = securityDomain.mapPermissions(this);
    }

    SecurityIdentity(SecurityIdentity old, PeerIdentity[] newPeerIdentities) {
        this.securityDomain = old.securityDomain;
        this.principal = old.principal;
        this.realmInfo = old.realmInfo;
        this.authorizationIdentity = old.authorizationIdentity;
        this.roleMappers = old.roleMappers;
        this.peerIdentities = newPeerIdentities;
        this.creationTime = old.creationTime;
        this.verifier = old.verifier;
    }

    SecurityIdentity(SecurityIdentity old, Map<String, RoleMapper> roleMappers) {
        this.securityDomain = old.securityDomain;
        this.principal = old.principal;
        this.realmInfo = old.realmInfo;
        this.authorizationIdentity = old.authorizationIdentity;
        this.roleMappers = roleMappers;
        this.peerIdentities = old.peerIdentities;
        this.creationTime = old.creationTime;
        this.verifier = old.verifier;
    }

    SecurityIdentity(SecurityIdentity old, PermissionVerifier verifier) {
        this.securityDomain = old.securityDomain;
        this.principal = old.principal;
        this.realmInfo = old.realmInfo;
        this.authorizationIdentity = old.authorizationIdentity;
        this.roleMappers = old.roleMappers;
        this.peerIdentities = old.peerIdentities;
        this.creationTime = old.creationTime;
        this.verifier = verifier;
    }

    SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    RealmInfo getRealmInfo() {
        return this.realmInfo;
    }

    AuthorizationIdentity getAuthorizationIdentity() {
        return this.authorizationIdentity;
    }

    PeerIdentity[] getPeerIdentities() {
        return this.peerIdentities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAs(Runnable action) {
        if (action == null) {
            return;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            PeerIdentity.runAsAll(action, this.peerIdentities);
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAs(Callable<T> action) throws Exception {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = PeerIdentity.runAsAll(action, this.peerIdentities);
            return t;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAs(PrivilegedAction<T> action) {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = PeerIdentity.runAsAll(action, this.peerIdentities);
            return t;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public <T> T runAs(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = PeerIdentity.runAsAll(action, this.peerIdentities);
            return t;
        }
        catch (RuntimeException | PrivilegedActionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, P> T runAs(P parameter, ParametricPrivilegedAction<T, P> action) {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = PeerIdentity.runAsAll(parameter, action, this.peerIdentities);
            return t;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public <T, P> T runAs(P parameter, ParametricPrivilegedExceptionAction<T, P> action) throws PrivilegedActionException {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = PeerIdentity.runAsAll(parameter, action, this.peerIdentities);
            return t;
        }
        catch (RuntimeException | PrivilegedActionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public <T, R> R runAsFunction(Function<T, R> action, T parameter) {
        if (action == null) {
            return null;
        }
        return (R)this.runAsFunction(Function::apply, action, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, U, R> R runAsFunction(BiFunction<T, U, R> action, T parameter1, U parameter2) {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            R r = PeerIdentity.runAsAllFunction(parameter1, parameter2, action, this.peerIdentities);
            return r;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public <T> void runAsConsumer(Consumer<T> action, T parameter) {
        if (action == null) {
            return;
        }
        this.runAsConsumer(Consumer::accept, action, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, U> void runAsConsumer(BiConsumer<T, U> action, T parameter1, U parameter2) {
        if (action == null) {
            return;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            PeerIdentity.runAsAllConsumer(parameter1, parameter2, action, this.peerIdentities);
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void runAsObjIntConsumer(ObjIntConsumer<T> action, T parameter1, int parameter2) {
        if (action == null) {
            return;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            PeerIdentity.runAsAllObjIntConsumer(parameter1, parameter2, action, this.peerIdentities);
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAsSupplier(Supplier<T> action) {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = PeerIdentity.runAsAllSupplier(action, this.peerIdentities);
            return t;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public Roles getRoles() {
        return this.securityDomain.mapRoles(this);
    }

    public Roles getRoles(String category) {
        return this.getRoles(category, false);
    }

    public Roles getRoles(String category, boolean fallbackToDefault) {
        RoleMapper roleMapper = this.roleMappers.get(category);
        return roleMapper == null ? (fallbackToDefault ? this.getRoles() : Roles.NONE) : roleMapper.mapRoles(this.securityDomain.mapRoles(this));
    }

    public SecurityIdentity withRoleMapper(String category, RoleMapper roleMapper) {
        Map<String, RoleMapper> newMap;
        Assert.checkNotNullParam((String)"category", (Object)category);
        Assert.checkNotNullParam((String)"roleMapper", (Object)roleMapper);
        Map<String, RoleMapper> roleMappers = this.roleMappers;
        RoleMapper existingRoleMapper = roleMappers.get(category);
        if (existingRoleMapper == roleMapper) {
            return this;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ChangeRoleMapperPermission(category));
        }
        if (roleMappers.isEmpty() || roleMappers.size() == 1 && roleMappers.keySet().iterator().next().equals(category)) {
            newMap = Collections.singletonMap(category, roleMapper);
        } else {
            newMap = new HashMap<String, RoleMapper>(roleMappers);
            newMap.put(category, roleMapper);
        }
        return new SecurityIdentity(this, newMap);
    }

    public SecurityIdentity createRunAsIdentity(String name) throws SecurityException {
        return this.createRunAsIdentity(name, true);
    }

    public SecurityIdentity createRunAsIdentity(String name, boolean authorize) throws SecurityException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_RUN_AS_PERMISSION);
        }
        SecurityDomain domain = this.securityDomain;
        ServerAuthenticationContext context = domain.createNewAuthenticationContext(this, MechanismConfigurationSelector.constantSelector(MechanismConfiguration.EMPTY));
        try {
            if (!context.importIdentity(this) || !context.authorize(name, authorize)) {
                throw ElytronMessages.log.runAsAuthorizationFailed(this.getPrincipal(), new NamePrincipal(name), null);
            }
        }
        catch (RealmUnavailableException e) {
            throw ElytronMessages.log.runAsAuthorizationFailed(this.principal, context.getAuthenticationPrincipal(), e);
        }
        return context.getAuthorizedIdentity();
    }

    public SecurityIdentity withPeerIdentity(PeerIdentity peerIdentity) {
        if (peerIdentity == null) {
            return this;
        }
        PeerIdentity[] peerIdentities = this.peerIdentities;
        int length = peerIdentities.length;
        for (int i = 0; i < length; ++i) {
            if (!peerIdentities[i].isSamePeerIdentityContext(peerIdentity)) continue;
            PeerIdentity[] newPeerIdentities = (PeerIdentity[])peerIdentities.clone();
            newPeerIdentities[i] = peerIdentity;
            return new SecurityIdentity(this, newPeerIdentities);
        }
        PeerIdentity[] newPeerIdentities = Arrays.copyOf(peerIdentities, length + 1);
        newPeerIdentities[length] = peerIdentity;
        return new SecurityIdentity(this, newPeerIdentities);
    }

    public SecurityIdentity intersectWith(PermissionVerifier verifier) {
        Assert.checkNotNullParam((String)"verifier", (Object)verifier);
        return new SecurityIdentity(this, this.verifier.and(verifier));
    }

    @Override
    public boolean implies(Permission permission) {
        return this.verifier.implies(permission);
    }

    @Override
    public Attributes getAttributes() {
        return this.authorizationIdentity.getAttributes().asReadOnly();
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public Instant getCreationTime() {
        return this.creationTime;
    }
}

