/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.callback.ChannelBindingCallback;

public final class TLSServerEndPointChannelBinding {
    public static final String TLS_SERVER_ENDPOINT = "tls-server-endpoint";

    private TLSServerEndPointChannelBinding() {
    }

    public static String getDigestAlgorithm(String sigAlgOID) {
        switch (sigAlgOID) {
            case "1.2.840.113549.2.2": 
            case "1.2.840.113549.1.1.2": 
            case "1.2.840.113549.1.1.3": 
            case "1.2.840.113549.2.5": 
            case "1.2.840.113549.1.1.4": 
            case "1.2.840.10040.4.3": 
            case "1.2.840.113549.1.1.5": 
            case "1.2.840.10045.4.1": 
            case "1.3.14.3.2.26": 
            case "1.2.840.10045.4.3.1": 
            case "1.2.840.113549.1.1.11": 
            case "1.2.840.10045.4.3.2": {
                return "SHA-256";
            }
            case "1.2.840.10045.4.3.3": 
            case "1.2.840.113549.1.1.12": {
                return "SHA-384";
            }
            case "1.2.840.10045.4.3.4": 
            case "1.2.840.113549.1.1.13": {
                return "SHA-512";
            }
        }
        return null;
    }

    public static void handleChannelBindingCallback(ChannelBindingCallback channelBindingCallback, X509Certificate[] serverCerts) throws UnsupportedCallbackException {
        X509Certificate serverCert;
        String digestAlgorithm;
        if (serverCerts != null && serverCerts.length > 0 && (digestAlgorithm = TLSServerEndPointChannelBinding.getDigestAlgorithm((serverCert = serverCerts[0]).getSigAlgOID())) != null) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(digestAlgorithm);
                channelBindingCallback.setBindingData(messageDigest.digest(serverCert.getEncoded()));
                channelBindingCallback.setBindingType(TLS_SERVER_ENDPOINT);
            }
            catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {
                // empty catch block
            }
        }
        CallbackUtil.unsupported(channelBindingCallback);
    }
}

