/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.net.URI;
import java.util.Arrays;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.MatchRule;

class MatchPurposeRule
extends MatchRule {
    private final String[] purposes;

    MatchPurposeRule(MatchRule parent, String[] purposes) {
        super(parent);
        this.purposes = purposes;
    }

    @Override
    String[] getMatchPurposesRaw() {
        return this.purposes;
    }

    @Override
    public boolean isPurposeMatched() {
        return true;
    }

    @Override
    public boolean matches(URI uri, String abstractType, String abstractTypeAuthority, String purpose) {
        return purpose != null && Arrays.binarySearch(this.purposes, purpose) >= 0 && super.matches(uri, abstractType, abstractTypeAuthority, purpose);
    }

    @Override
    MatchRule reparent(MatchRule newParent) {
        return new MatchPurposeRule(newParent, this.purposes);
    }

    @Override
    boolean halfEqual(MatchRule other) {
        return Arrays.equals(this.purposes, other.getMatchPurposesRaw()) && this.parentHalfEqual(other);
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashUnordered((int)this.parentHashCode(), (int)6733, (int)Arrays.hashCode(this.purposes));
    }

    @Override
    StringBuilder asString(StringBuilder b) {
        return this.parentAsString(b).append("purposes=").append(Arrays.toString(this.purposes)).append(',');
    }
}

