/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.sasl.digest._private.DigestUtil;
import org.wildfly.security.sasl.util.AbstractSaslParticipant;
import org.wildfly.security.sasl.util.SaslWrapper;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.ByteStringBuilder;
import org.wildfly.security.util.DefaultTransformationMapper;
import org.wildfly.security.util.TransformationSpec;
import org.wildfly.security.util._private.Arrays2;

abstract class AbstractDigestMechanism
extends AbstractSaslParticipant {
    private static final int MAX_PARSED_RESPONSE_SIZE = 13;
    private static int NONCE_SIZE = 36;
    public static final int DEFAULT_MAXBUF = 65536;
    public static final char DELIMITER = ',';
    public static final String[] CIPHER_OPTS = new String[]{"des", "3des", "rc4", "rc4-40", "rc4-56"};
    private FORMAT format;
    protected String digestURI;
    private Charset charset = StandardCharsets.ISO_8859_1;
    protected MessageDigest digest;
    protected String cipher;
    protected String qop;
    protected int wrapSeqNum;
    protected int unwrapSeqNum;
    protected byte[] nonce;
    protected byte[] cnonce;
    protected String authzid;
    protected byte[] hA1;
    protected SecureRandom secureRandomGenerator = new SecureRandom();
    protected Mac hmacMD5 = this.getHmac();
    protected Cipher wrapCipher = null;
    protected Cipher unwrapCipher = null;
    protected byte[] wrapHmacKeyIntegrity;
    protected byte[] unwrapHmacKeyIntegrity;
    protected final MessageDigest messageDigest;
    private static final String CLIENT_MAGIC_INTEGRITY = "Digest session key to client-to-server signing key magic constant";
    private static final String SERVER_MAGIC_INTEGRITY = "Digest session key to server-to-client signing key magic constant";
    private static final String CLIENT_MAGIC_CONFIDENTIALITY = "Digest H(A1) to client-to-server sealing key magic constant";
    private static final String SERVER_MAGIC_CONFIDENTIALITY = "Digest H(A1) to server-to-client sealing key magic constant";

    public AbstractDigestMechanism(String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler, FORMAT format, Charset charset, String[] ciphers) throws SaslException {
        super(mechanismName, protocol, serverName, callbackHandler);
        try {
            this.messageDigest = MessageDigest.getInstance(DigestUtil.messageDigestAlgorithm(mechanismName));
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.log.mechMacAlgorithmNotSupported(this.getMechanismName(), e).toSaslException();
        }
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.log.mechMacAlgorithmNotSupported(this.getMechanismName(), e).toSaslException();
        }
        this.format = format;
        this.digestURI = this.getProtocol() + "/" + this.getServerName();
        this.charset = charset != null ? charset : StandardCharsets.ISO_8859_1;
    }

    protected static int skipWhiteSpace(byte[] buffer, int startPoint) {
        int i;
        for (i = startPoint; i < buffer.length && AbstractDigestMechanism.isWhiteSpace(buffer[i]); ++i) {
        }
        return i;
    }

    protected static boolean isWhiteSpace(byte b) {
        if (b == 13) {
            return true;
        }
        if (b == 10) {
            return true;
        }
        if (b == 9) {
            return true;
        }
        return b == 32;
    }

    static String getSupportedCiphers(String[] demandedCiphers) {
        DefaultTransformationMapper trans = new DefaultTransformationMapper();
        if (demandedCiphers == null) {
            demandedCiphers = CIPHER_OPTS;
        }
        StringBuilder ciphers = new StringBuilder();
        for (TransformationSpec ts : trans.getTransformationSpecByStrength("DIGEST-MD5", demandedCiphers)) {
            if (ciphers.length() > 0) {
                ciphers.append(',');
            }
            ciphers.append(ts.getToken());
        }
        return ciphers.toString();
    }

    static byte[] generateNonce() {
        SecureRandom random = new SecureRandom();
        byte[] nonceData = new byte[NONCE_SIZE];
        random.nextBytes(nonceData);
        return ByteIterator.ofBytes(nonceData).base64Encode().drainToString().getBytes(StandardCharsets.US_ASCII);
    }

    HashMap<String, byte[]> parseResponse(byte[] challenge) throws SaslException {
        HashMap<String, byte[]> response = new HashMap<String, byte[]>(13);
        int i = AbstractDigestMechanism.skipWhiteSpace(challenge, 0);
        StringBuilder key = new StringBuilder(10);
        ByteStringBuilder value = new ByteStringBuilder();
        Integer realmNumber = new Integer(0);
        boolean insideKey = true;
        boolean insideQuotedValue = false;
        boolean expectSeparator = false;
        while (i < challenge.length) {
            byte b = challenge[i];
            if (insideKey) {
                if (b == 44) {
                    throw ElytronMessages.log.mechKeywordNotFollowedByEqual(this.getMechanismName(), key.toString()).toSaslException();
                }
                if (b == 61) {
                    if (key.length() == 0) {
                        throw ElytronMessages.log.mechKeywordCannotBeEmpty(this.getMechanismName()).toSaslException();
                    }
                    insideKey = false;
                    if ((i = AbstractDigestMechanism.skipWhiteSpace(challenge, i + 1)) < challenge.length) {
                        if (challenge[i] != 34) continue;
                        insideQuotedValue = true;
                        ++i;
                        continue;
                    }
                    throw ElytronMessages.log.mechNoValueFoundForKeyword(this.getMechanismName(), key.toString()).toSaslException();
                }
                if (AbstractDigestMechanism.isWhiteSpace(b)) {
                    if ((i = AbstractDigestMechanism.skipWhiteSpace(challenge, i + 1)) < challenge.length) {
                        if (challenge[i] == 61) continue;
                        throw ElytronMessages.log.mechKeywordNotFollowedByEqual(this.getMechanismName(), key.toString()).toSaslException();
                    }
                    throw ElytronMessages.log.mechKeywordNotFollowedByEqual(this.getMechanismName(), key.toString()).toSaslException();
                }
                key.append((char)(b & 0xFF));
                ++i;
                continue;
            }
            if (insideQuotedValue) {
                if (b == 92) {
                    if (++i < challenge.length) {
                        value.append(challenge[i]);
                        ++i;
                        continue;
                    }
                    throw ElytronMessages.log.mechUnmatchedQuoteFoundForValue(this.getMechanismName(), value.toString()).toSaslException();
                }
                if (b == 34) {
                    ++i;
                    insideQuotedValue = false;
                    expectSeparator = true;
                    continue;
                }
                value.append(b);
                ++i;
                continue;
            }
            if (AbstractDigestMechanism.isWhiteSpace(b) || b == 44) {
                realmNumber = this.addToParsedChallenge(response, key, value, realmNumber);
                key = new StringBuilder();
                value = new ByteStringBuilder();
                if ((i = AbstractDigestMechanism.skipWhiteSpace(challenge, i)) >= challenge.length || challenge[i] != 44) continue;
                expectSeparator = false;
                insideKey = true;
                ++i;
                continue;
            }
            if (expectSeparator) {
                String val = new String(value.toArray(), this.charset);
                throw ElytronMessages.log.mechExpectingCommaOrLinearWhitespaceAfterQuoted(this.getMechanismName(), val).toSaslException();
            }
            value.append(b);
            ++i;
        }
        if (insideQuotedValue) {
            throw ElytronMessages.log.mechUnmatchedQuoteFoundForValue(this.getMechanismName(), value.toString()).toSaslException();
        }
        if (key.length() > 0) {
            realmNumber = this.addToParsedChallenge(response, key, value, realmNumber);
        }
        return response;
    }

    private int addToParsedChallenge(HashMap<String, byte[]> response, StringBuilder keyBuilder, ByteStringBuilder valueBuilder, int realmNumber) {
        String k = keyBuilder.toString();
        byte[] v = valueBuilder.toArray();
        if (this.format == FORMAT.CLIENT && "realm".equals(k)) {
            response.put(k + ":" + String.valueOf(realmNumber), v);
            ++realmNumber;
        } else {
            response.put(k, v);
        }
        return realmNumber;
    }

    protected boolean arrayContains(String[] array, String searched) {
        for (String item : array) {
            if (!searched.equals(item)) continue;
            return true;
        }
        return false;
    }

    public Charset getCharset() {
        return this.charset;
    }

    private byte[] wrapIntegrityProtectedMessage(byte[] message, int offset, int len) throws SaslException {
        byte[] messageMac = DigestUtil.computeHMAC(this.wrapHmacKeyIntegrity, this.wrapSeqNum, this.hmacMD5, message, offset, len);
        byte[] result = new byte[len + 16];
        System.arraycopy(message, offset, result, 0, len);
        System.arraycopy(messageMac, 0, result, len, 10);
        DigestUtil.integerByteOrdered(1, result, len + 10, 2);
        DigestUtil.integerByteOrdered(this.wrapSeqNum, result, len + 12, 4);
        ++this.wrapSeqNum;
        return result;
    }

    private byte[] unwrapIntegrityProtectedMessage(byte[] message, int offset, int len) throws SaslException {
        int messageType = DigestUtil.decodeByteOrderedInteger(message, offset + len - 6, 2);
        int extractedSeqNum = DigestUtil.decodeByteOrderedInteger(message, offset + len - 4, 4);
        if (messageType != 1) {
            throw ElytronMessages.log.mechMessageTypeMustEqual(this.getMechanismName(), 1, messageType).toSaslException();
        }
        if (extractedSeqNum != this.unwrapSeqNum) {
            throw ElytronMessages.log.mechBadSequenceNumberWhileUnwrapping(this.getMechanismName(), this.unwrapSeqNum, extractedSeqNum).toSaslException();
        }
        byte[] extractedMessageMac = new byte[10];
        byte[] extractedMessage = new byte[len - 16];
        System.arraycopy(message, offset, extractedMessage, 0, len - 16);
        System.arraycopy(message, offset + len - 16, extractedMessageMac, 0, 10);
        byte[] expectedHmac = DigestUtil.computeHMAC(this.unwrapHmacKeyIntegrity, extractedSeqNum, this.hmacMD5, extractedMessage, 0, extractedMessage.length);
        if (!Arrays2.equals(expectedHmac, 0, extractedMessageMac, 0, 10)) {
            return NO_BYTES;
        }
        ++this.unwrapSeqNum;
        return extractedMessage;
    }

    private byte[] wrapConfidentialityProtectedMessage(byte[] message, int offset, int len) throws SaslException {
        byte[] messageMac = DigestUtil.computeHMAC(this.wrapHmacKeyIntegrity, this.wrapSeqNum, this.hmacMD5, message, offset, len);
        int paddingLength = 0;
        byte[] pad = null;
        int blockSize = this.wrapCipher.getBlockSize();
        if (blockSize > 0) {
            paddingLength = blockSize - (len + 10) % blockSize;
            pad = new byte[paddingLength];
            Arrays.fill(pad, (byte)paddingLength);
        }
        byte[] toCipher = new byte[len + paddingLength + 10];
        System.arraycopy(message, offset, toCipher, 0, len);
        if (paddingLength > 0) {
            System.arraycopy(pad, 0, toCipher, len, paddingLength);
        }
        System.arraycopy(messageMac, 0, toCipher, len + paddingLength, 10);
        byte[] cipheredPart = null;
        try {
            cipheredPart = this.wrapCipher.update(toCipher);
        }
        catch (Exception e) {
            throw ElytronMessages.log.mechProblemDuringCrypt(this.getMechanismName(), e).toSaslException();
        }
        byte[] result = new byte[cipheredPart.length + 6];
        System.arraycopy(cipheredPart, 0, result, 0, cipheredPart.length);
        DigestUtil.integerByteOrdered(1, result, cipheredPart.length, 2);
        DigestUtil.integerByteOrdered(this.wrapSeqNum, result, cipheredPart.length + 2, 4);
        ++this.wrapSeqNum;
        return result;
    }

    private byte[] unwrapConfidentialityProtectedMessage(byte[] message, int offset, int len) throws SaslException {
        int messageType = DigestUtil.decodeByteOrderedInteger(message, offset + len - 6, 2);
        int extractedSeqNum = DigestUtil.decodeByteOrderedInteger(message, offset + len - 4, 4);
        if (messageType != 1) {
            throw ElytronMessages.log.mechMessageTypeMustEqual(this.getMechanismName(), 1, messageType).toSaslException();
        }
        if (extractedSeqNum != this.unwrapSeqNum) {
            throw ElytronMessages.log.mechBadSequenceNumberWhileUnwrapping(this.getMechanismName(), this.unwrapSeqNum, extractedSeqNum).toSaslException();
        }
        byte[] clearText = null;
        try {
            clearText = this.unwrapCipher.update(message, offset, len - 6);
        }
        catch (Exception e) {
            throw ElytronMessages.log.mechProblemDuringDecrypt(this.getMechanismName(), e).toSaslException();
        }
        byte[] hmac = new byte[10];
        System.arraycopy(clearText, clearText.length - 10, hmac, 0, 10);
        byte[] decryptedMessage = null;
        if (this.unwrapCipher.getBlockSize() > 0) {
            byte padSize = clearText[clearText.length - 10 - 1];
            int decryptedMessageSize = clearText.length - 10;
            if (padSize < 8) {
                int i = clearText.length - 10 - 1;
                while (clearText[i] == padSize) {
                    --i;
                }
                decryptedMessageSize = i + 1;
            }
            decryptedMessage = new byte[decryptedMessageSize];
            System.arraycopy(clearText, 0, decryptedMessage, 0, decryptedMessageSize);
        } else {
            decryptedMessage = new byte[clearText.length - 10];
            System.arraycopy(clearText, 0, decryptedMessage, 0, clearText.length - 10);
        }
        byte[] expectedHmac = DigestUtil.computeHMAC(this.unwrapHmacKeyIntegrity, extractedSeqNum, this.hmacMD5, decryptedMessage, 0, decryptedMessage.length);
        if (!Arrays2.equals(expectedHmac, 0, hmac, 0, 10)) {
            return NO_BYTES;
        }
        ++this.unwrapSeqNum;
        return decryptedMessage;
    }

    protected void createCiphersAndKeys() throws SaslException {
        this.wrapHmacKeyIntegrity = this.createIntegrityKey(true);
        this.unwrapHmacKeyIntegrity = this.createIntegrityKey(false);
        if (this.cipher == null || this.cipher.length() == 0) {
            return;
        }
        this.wrapCipher = this.createCipher(true);
        this.unwrapCipher = this.createCipher(false);
    }

    protected byte[] createIntegrityKey(boolean wrap) {
        ByteStringBuilder key = new ByteStringBuilder(this.hA1);
        if (wrap) {
            key.append(this.format == FORMAT.CLIENT ? CLIENT_MAGIC_INTEGRITY : SERVER_MAGIC_INTEGRITY);
        } else {
            key.append(this.format == FORMAT.CLIENT ? SERVER_MAGIC_INTEGRITY : CLIENT_MAGIC_INTEGRITY);
        }
        this.digest.reset();
        return this.digest.digest(key.toArray());
    }

    protected Cipher createCipher(boolean wrap) throws SaslException {
        Cipher ciph;
        byte[] hmacKey;
        int n = this.gethA1PrefixLength(this.cipher);
        ByteStringBuilder key = new ByteStringBuilder();
        key.append(this.hA1, 0, n);
        if (wrap) {
            key.append(this.format == FORMAT.CLIENT ? CLIENT_MAGIC_CONFIDENTIALITY : SERVER_MAGIC_CONFIDENTIALITY);
            hmacKey = this.digest.digest(key.toArray());
        } else {
            key.append(this.format == FORMAT.CLIENT ? SERVER_MAGIC_CONFIDENTIALITY : CLIENT_MAGIC_CONFIDENTIALITY);
            hmacKey = this.digest.digest(key.toArray());
        }
        DefaultTransformationMapper trans = new DefaultTransformationMapper();
        byte[] IV = null;
        try {
            SecretKey cipherKey;
            String alg;
            ciph = Cipher.getInstance(trans.getTransformationSpec("DIGEST-MD5", this.cipher).getTransformation());
            int slash = ciph.getAlgorithm().indexOf(47);
            String string = alg = slash > -1 ? ciph.getAlgorithm().substring(0, slash) : ciph.getAlgorithm();
            if (this.cipher.startsWith("rc")) {
                byte[] cipherKeyBytes = (byte[])hmacKey.clone();
                cipherKey = new SecretKeySpec(cipherKeyBytes, alg);
            } else if (this.cipher.equals("des")) {
                byte[] cipherKeyBytes = Arrays.copyOf(hmacKey, 7);
                IV = Arrays.copyOfRange(hmacKey, 8, 16);
                cipherKey = DigestUtil.createDesSecretKey(cipherKeyBytes);
            } else if (this.cipher.equals("3des")) {
                byte[] cipherKeyBytes = Arrays.copyOf(hmacKey, 14);
                IV = Arrays.copyOfRange(hmacKey, 8, 16);
                cipherKey = DigestUtil.create3desSecretKey(cipherKeyBytes);
            } else {
                throw ElytronMessages.log.mechUnknownCipher(this.getMechanismName(), this.cipher).toSaslException();
            }
            if (IV != null) {
                ciph.init(wrap ? 1 : 2, (Key)cipherKey, new IvParameterSpec(IV), this.secureRandomGenerator);
            } else {
                ciph.init(wrap ? 1 : 2, (Key)cipherKey, this.secureRandomGenerator);
            }
        }
        catch (Exception e) {
            throw ElytronMessages.log.mechProblemGettingRequiredCipher(this.getMechanismName(), e).toSaslException();
        }
        return ciph;
    }

    private int gethA1PrefixLength(String cipher) {
        if (cipher.equals("rc4-40")) {
            return 5;
        }
        if (cipher.equals("rc4-56")) {
            return 7;
        }
        return 16;
    }

    private Mac getHmac() throws SaslException {
        try {
            return Mac.getInstance("HmacMD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.log.mechMacAlgorithmNotSupported(this.getMechanismName(), e).toSaslException();
        }
    }

    protected byte[] getPredigestedSaltedPassword(RealmCallback realmCallback, NameCallback nameCallback) throws SaslException {
        CredentialCallback credentialCallback = new CredentialCallback(PasswordCredential.class, this.passwordAlgorithm(this.getMechanismName()));
        try {
            this.tryHandleCallbacks(realmCallback, nameCallback, credentialCallback);
            PasswordCredential credential = (PasswordCredential)credentialCallback.getCredential();
            DigestPassword password = (DigestPassword)credential.getPassword();
            return password.getDigest();
        }
        catch (UnsupportedCallbackException e) {
            if (e.getCallback() == credentialCallback) {
                return null;
            }
            if (e.getCallback() == nameCallback) {
                throw ElytronMessages.log.mechCallbackHandlerDoesNotSupportUserName(this.getMechanismName(), e).toSaslException();
            }
            throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason(this.getMechanismName(), e).toSaslException();
        }
    }

    protected byte[] getSaltedPasswordFromTwoWay(RealmCallback realmCallback, NameCallback nameCallback, boolean readOnlyRealmUsername) throws SaslException {
        CredentialCallback credentialCallback = new CredentialCallback(PasswordCredential.class, "clear");
        try {
            this.tryHandleCallbacks(realmCallback, nameCallback, credentialCallback);
        }
        catch (UnsupportedCallbackException e) {
            if (e.getCallback() == credentialCallback) {
                return null;
            }
            if (e.getCallback() == nameCallback) {
                throw ElytronMessages.log.mechCallbackHandlerDoesNotSupportUserName(this.getMechanismName(), e).toSaslException();
            }
            throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason(this.getMechanismName(), e).toSaslException();
        }
        Credential credential = credentialCallback.getCredential();
        TwoWayPassword password = ((PasswordCredential)credential).getPassword(TwoWayPassword.class);
        char[] passwordChars = DigestUtil.getTwoWayPasswordChars(this.getMechanismName(), password);
        try {
            password.destroy();
        }
        catch (DestroyFailedException e) {
            ElytronMessages.log.credentialDestroyingFailed(e);
        }
        String realm = readOnlyRealmUsername ? realmCallback.getDefaultText() : realmCallback.getText();
        String username = readOnlyRealmUsername ? nameCallback.getDefaultName() : nameCallback.getName();
        byte[] digest_urp = DigestUtil.userRealmPasswordDigest(this.messageDigest, username, realm, passwordChars);
        if (passwordChars != null) {
            Arrays.fill(passwordChars, '\u0000');
        }
        return digest_urp;
    }

    protected byte[] getSaltedPasswordFromPasswordCallback(RealmCallback realmCallback, NameCallback nameCallback, boolean readOnlyRealmUsername) throws SaslException {
        PasswordCallback passwordCallback = new PasswordCallback("User password", false);
        try {
            this.tryHandleCallbacks(realmCallback, nameCallback, passwordCallback);
        }
        catch (UnsupportedCallbackException e) {
            if (e.getCallback() == passwordCallback) {
                return null;
            }
            if (e.getCallback() == nameCallback) {
                throw ElytronMessages.log.mechCallbackHandlerDoesNotSupportUserName(this.getMechanismName(), e).toSaslException();
            }
            throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason(this.getMechanismName(), e).toSaslException();
        }
        char[] passwordChars = passwordCallback.getPassword();
        passwordCallback.clearPassword();
        if (passwordChars == null) {
            throw ElytronMessages.log.mechNoPasswordGiven(this.getMechanismName()).toSaslException();
        }
        if (!readOnlyRealmUsername && nameCallback.getName() == null) {
            throw ElytronMessages.log.mechNotProvidedUserName(this.getMechanismName()).toSaslException();
        }
        String realm = readOnlyRealmUsername ? realmCallback.getDefaultText() : realmCallback.getText();
        String username = readOnlyRealmUsername ? nameCallback.getDefaultName() : nameCallback.getName();
        byte[] digest_urp = DigestUtil.userRealmPasswordDigest(this.messageDigest, username, realm, passwordChars);
        Arrays.fill(passwordChars, '\u0000');
        return digest_urp;
    }

    private String passwordAlgorithm(String mechanismName) {
        switch (mechanismName) {
            case "DIGEST-SHA": {
                return "digest-sha";
            }
            case "DIGEST-SHA-256": {
                return "digest-sha-256";
            }
            case "DIGEST-SHA-384": {
                return "digest-sha-384";
            }
            case "DIGEST-SHA-512": {
                return "digest-sha-512";
            }
            case "DIGEST-MD5": {
                return "digest-md5";
            }
        }
        throw Assert.impossibleSwitchCase((Object)mechanismName);
    }

    protected class DigestWrapper
    implements SaslWrapper {
        private boolean confidential;

        protected DigestWrapper(boolean confidential) {
            this.confidential = confidential;
        }

        @Override
        public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
            if (this.confidential) {
                return AbstractDigestMechanism.this.wrapConfidentialityProtectedMessage(outgoing, offset, len);
            }
            return AbstractDigestMechanism.this.wrapIntegrityProtectedMessage(outgoing, offset, len);
        }

        @Override
        public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
            if (this.confidential) {
                return AbstractDigestMechanism.this.unwrapConfidentialityProtectedMessage(incoming, offset, len);
            }
            return AbstractDigestMechanism.this.unwrapIntegrityProtectedMessage(incoming, offset, len);
        }
    }

    public static enum FORMAT {
        CLIENT,
        SERVER;

    }
}

