/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.AvailableRealmsCallback;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.impl.BasicAuthenticationMechanism;
import org.wildfly.security.http.impl.ClientCertAuthenticationMechanism;

public class ServerMechanismFactoryImpl
implements HttpServerAuthenticationMechanismFactory {
    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        ArrayList<String> mechanismNames = new ArrayList<String>();
        mechanismNames.add("BASIC");
        mechanismNames.add("CLIENT_CERT");
        return mechanismNames.toArray(new String[mechanismNames.size()]);
    }

    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        switch (mechanismName) {
            case "BASIC": {
                String[] realms = null;
                AvailableRealmsCallback availableRealmsCallback = new AvailableRealmsCallback();
                try {
                    callbackHandler.handle(new Callback[]{availableRealmsCallback});
                    realms = availableRealmsCallback.getRealmNames();
                }
                catch (UnsupportedCallbackException unsupportedCallbackException) {
                }
                catch (HttpAuthenticationException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason(mechanismName, e).toHttpAuthenticationException();
                }
                return new BasicAuthenticationMechanism(callbackHandler, realms == null || realms.length == 0 ? null : realms[0], false);
            }
            case "CLIENT_CERT": {
                return new ClientCertAuthenticationMechanism(callbackHandler);
            }
        }
        return null;
    }
}

