/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.UnrecoverableEntryException;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public class KeyStoreBackedSecurityRealm
implements SecurityRealm {
    private final KeyStore keyStore;

    public KeyStoreBackedSecurityRealm(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    public RealmIdentity getRealmIdentity(String name, Principal principal, Evidence evidence) throws RealmUnavailableException {
        if (name == null) {
            return RealmIdentity.NON_EXISTENT;
        }
        return new KeyStoreRealmIdentity(name);
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"evidenceType", evidenceType);
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    private KeyStore.Entry getEntry(String name) {
        try {
            return this.keyStore.getEntry(name, null);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (UnrecoverableEntryException e) {
            return null;
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    private class KeyStoreRealmIdentity
    implements RealmIdentity {
        private final String name;

        private KeyStoreRealmIdentity(String name) {
            this.name = name;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name);
            if (entry == null) {
                return SupportLevel.UNSUPPORTED;
            }
            Credential credential = Credential.fromKeyStoreEntry(entry);
            if (credentialType.isInstance(credential) && (algorithmName == null || credential instanceof AlgorithmCredential && algorithmName.equals(((AlgorithmCredential)credential).getAlgorithm()))) {
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name);
            if (entry == null) {
                return null;
            }
            Credential credential = Credential.fromKeyStoreEntry(entry);
            if (credentialType.isInstance(credential) && (algorithmName == null || credential instanceof AlgorithmCredential && algorithmName.equals(((AlgorithmCredential)credential).getAlgorithm()))) {
                return (C)((Credential)credentialType.cast(credential));
            }
            return null;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.getCredential(credentialType, null);
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() {
            return AuthorizationIdentity.EMPTY;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name);
            if (entry == null) {
                return SupportLevel.UNSUPPORTED;
            }
            Credential credential = Credential.fromKeyStoreEntry(entry);
            if (credential != null && credential.canVerify(evidenceType, algorithmName)) {
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name);
            if (entry == null) {
                return false;
            }
            Credential credential = Credential.fromKeyStoreEntry(entry);
            return credential != null && credential.canVerify(evidence) && credential.verify(evidence);
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return KeyStoreBackedSecurityRealm.this.getEntry(this.name) != null;
        }

        @Override
        public boolean createdBySecurityRealm(SecurityRealm securityRealm) {
            return KeyStoreBackedSecurityRealm.this == securityRealm;
        }
    }
}

