/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl;

import java.util.Arrays;
import java.util.function.Predicate;
import javax.net.ssl.SSLSession;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.sasl.util.SaslMechanismInformation;

public abstract class SaslMechanismPredicate {
    private int hashCode;
    static final BooleanPredicate TRUE = new BooleanPredicate(true);
    static final BooleanPredicate FALSE = new BooleanPredicate(false);
    static final SaslMechanismPredicate TLS_ACTIVE = new SaslMechanismPredicate(){

        @Override
        boolean test(String mechName, SSLSession sslSession) {
            return sslSession != null;
        }

        @Override
        void toString(StringBuilder b) {
            b.append("#TLS");
        }

        @Override
        public boolean equals(SaslMechanismPredicate other) {
            return this == other;
        }

        @Override
        int calcHashCode() {
            return this.getClass().hashCode();
        }
    };
    static final SaslMechanismPredicate PLUS = new SaslMechanismPredicate(){

        @Override
        boolean test(String mechName, SSLSession sslSession) {
            return sslSession != null && SaslMechanismInformation.BINDING.test(mechName);
        }

        @Override
        void toString(StringBuilder b) {
            b.append("#PLUS");
        }

        @Override
        public boolean equals(SaslMechanismPredicate other) {
            return this == other;
        }

        @Override
        int calcHashCode() {
            return this.getClass().hashCode();
        }
    };
    static final SaslMechanismPredicate MUTUAL = new SaslMechanismPredicate(){

        @Override
        boolean test(String mechName, SSLSession sslSession) {
            return sslSession != null && SaslMechanismInformation.MUTUAL.test(mechName);
        }

        @Override
        void toString(StringBuilder b) {
            b.append("#MUTUAL");
        }

        @Override
        public boolean equals(SaslMechanismPredicate other) {
            return this == other;
        }

        @Override
        int calcHashCode() {
            return this.getClass().hashCode();
        }
    };

    SaslMechanismPredicate() {
    }

    abstract boolean test(String var1, SSLSession var2);

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b);
        return b.toString();
    }

    abstract void toString(StringBuilder var1);

    public static SaslMechanismPredicate matchTrue() {
        return TRUE;
    }

    public static SaslMechanismPredicate matchFalse() {
        return FALSE;
    }

    public static SaslMechanismPredicate matchAll(SaslMechanismPredicate ... predicates) {
        return new AllPredicate(predicates);
    }

    public static SaslMechanismPredicate matchAllOrNone(SaslMechanismPredicate ... predicates) {
        return new AllOrNonePredicate(predicates);
    }

    public static SaslMechanismPredicate matchAny(SaslMechanismPredicate ... predicates) {
        return new AnyPredicate(predicates);
    }

    public static SaslMechanismPredicate matchNot(SaslMechanismPredicate predicate) {
        Assert.checkNotNullParam((String)"predicate", (Object)predicate);
        return predicate.not();
    }

    public static SaslMechanismPredicate matchIf(SaslMechanismPredicate conditionPredicate, SaslMechanismPredicate truePredicate, SaslMechanismPredicate falsePredicate) {
        Assert.checkNotNullParam((String)"conditionPredicate", (Object)conditionPredicate);
        Assert.checkNotNullParam((String)"truePredicate", (Object)truePredicate);
        Assert.checkNotNullParam((String)"falsePredicate", (Object)falsePredicate);
        return new IfPredicate(conditionPredicate, truePredicate, falsePredicate);
    }

    public static SaslMechanismPredicate matchExact(String name) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return new ExactPredicate(name);
    }

    public static SaslMechanismPredicate matchHashFunction(String digest) {
        Assert.checkNotNullParam((String)"digest", (Object)digest);
        return new HashPredicate(digest);
    }

    public static SaslMechanismPredicate matchPlus() {
        return PLUS;
    }

    public static SaslMechanismPredicate matchMutual() {
        return MUTUAL;
    }

    public static SaslMechanismPredicate matchFamily(String name) {
        Predicate<String> predicate;
        Assert.checkNotNullParam((String)"name", (Object)name);
        switch (name) {
            case "DIGEST": {
                predicate = SaslMechanismInformation.DIGEST;
                break;
            }
            case "EAP": {
                predicate = SaslMechanismInformation.EAP;
                break;
            }
            case "GS2": {
                predicate = SaslMechanismInformation.GS2;
                break;
            }
            case "SCRAM": {
                predicate = SaslMechanismInformation.SCRAM;
                break;
            }
            case "IEC-ISO-9798": {
                predicate = SaslMechanismInformation.IEC_ISO_9798;
                break;
            }
            default: {
                predicate = s -> false;
            }
        }
        return new FamilyPredicate(predicate, name);
    }

    public static SaslMechanismPredicate matchTLSActive() {
        return TLS_ACTIVE;
    }

    public final boolean equals(Object obj) {
        return obj instanceof SaslMechanismPredicate && this.equals((SaslMechanismPredicate)obj);
    }

    public abstract boolean equals(SaslMechanismPredicate var1);

    public final int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode == 0) {
            hashCode = this.calcHashCode();
            if (hashCode == 0) {
                hashCode = 1;
            }
            this.hashCode = hashCode;
            return this.hashCode;
        }
        return hashCode;
    }

    abstract int calcHashCode();

    SaslMechanismPredicate not() {
        return new NotPredicate(this);
    }

    static class HashPredicate
    extends SaslMechanismPredicate {
        private final String digest;

        HashPredicate(String digest) {
            this.digest = digest;
        }

        @Override
        boolean test(String mechName, SSLSession sslSession) {
            switch (this.digest) {
                case "MD5": {
                    return SaslMechanismInformation.HASH_MD5.test(mechName);
                }
                case "SHA-1": {
                    return SaslMechanismInformation.HASH_SHA.test(mechName);
                }
                case "SHA-256": {
                    return SaslMechanismInformation.HASH_SHA_256.test(mechName);
                }
                case "SHA-384": {
                    return SaslMechanismInformation.HASH_SHA_384.test(mechName);
                }
                case "SHA-512": {
                    return SaslMechanismInformation.HASH_SHA_512.test(mechName);
                }
            }
            return false;
        }

        @Override
        void toString(StringBuilder b) {
            b.append("#HASH(").append(this.digest).append(')');
        }

        @Override
        public boolean equals(SaslMechanismPredicate other) {
            return other instanceof HashPredicate && this.digest.equals(((HashPredicate)other).digest);
        }

        @Override
        int calcHashCode() {
            return 0;
        }
    }

    static class IfPredicate
    extends SaslMechanismPredicate {
        private final SaslMechanismPredicate conditionPredicate;
        private final SaslMechanismPredicate truePredicate;
        private final SaslMechanismPredicate falsePredicate;

        IfPredicate(SaslMechanismPredicate conditionPredicate, SaslMechanismPredicate truePredicate, SaslMechanismPredicate falsePredicate) {
            this.conditionPredicate = conditionPredicate;
            this.truePredicate = truePredicate;
            this.falsePredicate = falsePredicate;
        }

        @Override
        boolean test(String mechName, SSLSession sslSession) {
            return this.conditionPredicate.test(mechName, sslSession) ? this.truePredicate.test(mechName, sslSession) : this.falsePredicate.test(mechName, sslSession);
        }

        @Override
        void toString(StringBuilder b) {
            b.append('(').append(this.conditionPredicate).append('?').append(this.truePredicate).append(':').append(this.falsePredicate).append(')');
        }

        @Override
        public boolean equals(SaslMechanismPredicate other) {
            return this == other || other instanceof IfPredicate && this.equals((IfPredicate)other);
        }

        private boolean equals(IfPredicate other) {
            return this.conditionPredicate.equals(other.conditionPredicate) && this.truePredicate.equals(other.truePredicate) && this.falsePredicate.equals(other.falsePredicate);
        }

        @Override
        int calcHashCode() {
            return HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)this.getClass().hashCode(), (int)this.conditionPredicate.hashCode()), (int)this.truePredicate.hashCode()), (int)this.falsePredicate.hashCode());
        }
    }

    static class FamilyPredicate
    extends SaslMechanismPredicate {
        private final Predicate<String> predicate;
        private final String name;

        FamilyPredicate(Predicate<String> predicate, String name) {
            this.predicate = predicate;
            this.name = name;
        }

        @Override
        boolean test(String mechName, SSLSession sslSession) {
            return this.predicate.test(mechName);
        }

        @Override
        void toString(StringBuilder b) {
            b.append("#FAMILY(").append(this.name).append(')');
        }

        @Override
        public boolean equals(SaslMechanismPredicate other) {
            return other instanceof FamilyPredicate && this.equals((FamilyPredicate)other);
        }

        private boolean equals(FamilyPredicate other) {
            return this.predicate.equals(other.predicate) && this.name.equals(other.name);
        }

        @Override
        int calcHashCode() {
            return HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)this.getClass().hashCode(), (int)this.predicate.hashCode()), (int)this.name.hashCode());
        }
    }

    static class ExactPredicate
    extends SaslMechanismPredicate {
        private final String mechName;

        ExactPredicate(String mechName) {
            this.mechName = mechName;
        }

        @Override
        boolean test(String mechName, SSLSession sslSession) {
            return this.mechName.equals(mechName);
        }

        @Override
        void toString(StringBuilder b) {
            b.append(this.mechName);
        }

        @Override
        public boolean equals(SaslMechanismPredicate other) {
            return other instanceof ExactPredicate && this.mechName.equals(((ExactPredicate)other).mechName);
        }

        @Override
        int calcHashCode() {
            return this.getClass().hashCode() * 19 + this.mechName.hashCode();
        }
    }

    static class NotPredicate
    extends SaslMechanismPredicate {
        private final SaslMechanismPredicate predicate;

        NotPredicate(SaslMechanismPredicate predicate) {
            this.predicate = predicate;
        }

        @Override
        boolean test(String mechName, SSLSession sslSession) {
            return !this.predicate.test(mechName, sslSession);
        }

        @Override
        void toString(StringBuilder b) {
            b.append('!');
            this.predicate.toString(b);
        }

        @Override
        public boolean equals(SaslMechanismPredicate other) {
            return other instanceof NotPredicate && this.predicate.equals(((NotPredicate)other).predicate);
        }

        @Override
        int calcHashCode() {
            return this.getClass().hashCode() * 19 + this.predicate.calcHashCode();
        }

        @Override
        SaslMechanismPredicate not() {
            return this.predicate;
        }
    }

    static final class AnyPredicate
    extends MultiPredicate {
        AnyPredicate(SaslMechanismPredicate[] predicates) {
            super(predicates);
        }

        @Override
        boolean test(String mechName, SSLSession sslSession) {
            for (SaslMechanismPredicate predicate : this.predicates) {
                if (!predicate.test(mechName, sslSession)) continue;
                return true;
            }
            return false;
        }

        @Override
        void appendOperator(StringBuilder b) {
            b.append('|').append('|');
        }
    }

    static final class AllOrNonePredicate
    extends MultiPredicate {
        AllOrNonePredicate(SaslMechanismPredicate[] predicates) {
            super(predicates);
        }

        @Override
        boolean test(String mechName, SSLSession sslSession) {
            int length = this.predicates.length;
            if (length == 0) {
                return true;
            }
            boolean val = this.predicates[0].test(mechName, sslSession);
            for (int i = 1; i < length; ++i) {
                SaslMechanismPredicate predicate = this.predicates[i];
                if (val == predicate.test(mechName, sslSession)) continue;
                return false;
            }
            return true;
        }

        @Override
        void appendOperator(StringBuilder b) {
            b.append('=').append('=');
        }
    }

    static final class AllPredicate
    extends MultiPredicate {
        AllPredicate(SaslMechanismPredicate[] predicates) {
            super(predicates);
        }

        @Override
        boolean test(String mechName, SSLSession sslSession) {
            for (SaslMechanismPredicate predicate : this.predicates) {
                if (predicate.test(mechName, sslSession)) continue;
                return false;
            }
            return true;
        }

        @Override
        void appendOperator(StringBuilder b) {
            b.append('&').append('&');
        }
    }

    static abstract class MultiPredicate
    extends SaslMechanismPredicate {
        final SaslMechanismPredicate[] predicates;

        MultiPredicate(SaslMechanismPredicate[] predicates) {
            for (int i = 0; i < predicates.length; ++i) {
                SaslMechanismPredicate predicate = predicates[i];
                Assert.checkNotNullArrayParam((String)"predicates", (int)i, (Object)predicate);
            }
            this.predicates = predicates;
        }

        @Override
        void toString(StringBuilder b) {
            b.append('(');
            int length = this.predicates.length;
            if (length > 0) {
                b.append(this.predicates[0]);
                for (int i = 1; i < length; ++i) {
                    this.appendOperator(b);
                    b.append(this.predicates[i]);
                }
            }
            b.append(')');
        }

        @Override
        public boolean equals(SaslMechanismPredicate other) {
            return other.getClass() == this.getClass() && Arrays.equals(this.predicates, ((MultiPredicate)other).predicates);
        }

        @Override
        int calcHashCode() {
            int hc = this.getClass().hashCode() * 19;
            for (SaslMechanismPredicate predicate : this.predicates) {
                hc = HashMath.multiHashUnordered((int)hc, (int)predicate.calcHashCode());
            }
            return hc;
        }

        abstract void appendOperator(StringBuilder var1);
    }

    static final class BooleanPredicate
    extends SaslMechanismPredicate {
        private final boolean value;

        BooleanPredicate(boolean value) {
            this.value = value;
        }

        @Override
        boolean test(String mechName, SSLSession sslSession) {
            return this.value;
        }

        @Override
        void toString(StringBuilder b) {
            b.append(this.value);
        }

        @Override
        SaslMechanismPredicate not() {
            return this.value ? FALSE : TRUE;
        }

        @Override
        public boolean equals(SaslMechanismPredicate other) {
            return this == other;
        }

        @Override
        int calcHashCode() {
            return this.getClass().hashCode() * 19 + (this.value ? 1 : 0);
        }
    }
}

