/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.net.URI;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.MatchRule;

class MatchAbstractTypeRule
extends MatchRule {
    private final String type;

    MatchAbstractTypeRule(MatchRule parent, String type) {
        super(parent);
        this.type = type;
    }

    @Override
    public String getMatchAbstractType() {
        return this.type;
    }

    @Override
    public boolean isTypeMatched() {
        return true;
    }

    @Override
    public boolean matches(URI uri, String abstractType, String abstractTypeAuthority, String purpose) {
        return this.type.equals(abstractType) && super.matches(uri, abstractType, abstractTypeAuthority, purpose);
    }

    @Override
    MatchRule reparent(MatchRule newParent) {
        return new MatchAbstractTypeRule(newParent, this.type);
    }

    @Override
    boolean halfEqual(MatchRule other) {
        return this.type.equals(other.getMatchAbstractType()) && this.parentHalfEqual(other);
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashUnordered((int)this.parentHashCode(), (int)5693, (int)this.type.hashCode());
    }

    @Override
    StringBuilder asString(StringBuilder b) {
        return this.parentAsString(b).append("abstractType=").append(this.type).append(',');
    }
}

