/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.ldap.EvidenceVerifier;
import org.wildfly.security.auth.realm.ldap.IdentityEvidenceVerifier;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;
import org.wildfly.security.util.ByteIterator;

class X509EvidenceVerifier
implements EvidenceVerifier {
    private final List<CertificateVerifier> certificateVerifiers;

    X509EvidenceVerifier(List<CertificateVerifier> certificateVerifiers) {
        this.certificateVerifiers = certificateVerifiers;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return evidenceType == X509PeerCertificateChainEvidence.class ? SupportLevel.POSSIBLY_SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    @Override
    public IdentityEvidenceVerifier forIdentity(DirContext dirContext, String distinguishedName, String url, final Attributes attributes) throws RealmUnavailableException {
        return new IdentityEvidenceVerifier(){

            @Override
            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName, Supplier<Provider[]> providers) throws RealmUnavailableException {
                return evidenceType == X509PeerCertificateChainEvidence.class ? SupportLevel.POSSIBLY_SUPPORTED : SupportLevel.UNSUPPORTED;
            }

            @Override
            public boolean verifyEvidence(Evidence evidence, Supplier<Provider[]> providers) throws RealmUnavailableException {
                if (evidence instanceof X509PeerCertificateChainEvidence) {
                    X509Certificate certificate = ((X509PeerCertificateChainEvidence)evidence).getFirstCertificate();
                    try {
                        for (CertificateVerifier certificateVerifier : X509EvidenceVerifier.this.certificateVerifiers) {
                            if (certificateVerifier.verifyCertificate(certificate, attributes)) continue;
                            ElytronMessages.log.tracef("X509 client certificate rejected by %s of X509EvidenceVerifier", certificateVerifier);
                            return false;
                        }
                        ElytronMessages.log.trace("X509 client certificate accepted by X509EvidenceVerifier");
                        return true;
                    }
                    catch (NamingException e) {
                        throw new RealmUnavailableException(e);
                    }
                }
                return false;
            }
        };
    }

    @Override
    public void addRequiredIdentityAttributes(Collection<String> attributes) {
        for (CertificateVerifier verifier : this.certificateVerifiers) {
            verifier.addRequiredLdapAttributes(attributes);
        }
    }

    @Override
    public void addBinaryIdentityAttributes(Collection<String> attributes) {
        for (CertificateVerifier verifier : this.certificateVerifiers) {
            verifier.addBinaryLdapAttributes(attributes);
        }
    }

    static class EncodedCertificateVerifier
    implements CertificateVerifier {
        final String ldapAttribute;

        EncodedCertificateVerifier(String ldapAttribute) {
            this.ldapAttribute = ldapAttribute;
        }

        @Override
        public void addRequiredLdapAttributes(Collection<String> requiredAttributes) {
            requiredAttributes.add(this.ldapAttribute);
        }

        @Override
        public void addBinaryLdapAttributes(Collection<String> binaryAttributes) {
            binaryAttributes.add(this.ldapAttribute);
        }

        @Override
        public boolean verifyCertificate(X509Certificate certificate, Attributes attributes) throws NamingException, RealmUnavailableException {
            Attribute attribute = attributes.get(this.ldapAttribute);
            int size = attribute.size();
            try {
                for (int i = 0; i < size; ++i) {
                    if (!Arrays.equals(certificate.getEncoded(), (byte[])attribute.get(i))) continue;
                    return true;
                }
            }
            catch (CertificateEncodingException e) {
                throw new RealmUnavailableException(e);
            }
            return false;
        }
    }

    static class DigestCertificateVerifier
    implements CertificateVerifier {
        final String ldapAttribute;
        final String algorithm;

        DigestCertificateVerifier(String ldapAttribute, String algorithm) {
            this.ldapAttribute = ldapAttribute;
            this.algorithm = algorithm;
        }

        @Override
        public void addRequiredLdapAttributes(Collection<String> requiredAttributes) {
            requiredAttributes.add(this.ldapAttribute);
        }

        @Override
        public boolean verifyCertificate(X509Certificate certificate, Attributes attributes) throws NamingException, RealmUnavailableException {
            Attribute attribute = attributes.get(this.ldapAttribute);
            int size = attribute.size();
            try {
                MessageDigest md = MessageDigest.getInstance(this.algorithm);
                for (int i = 0; i < size; ++i) {
                    String digest = ByteIterator.ofBytes(md.digest(certificate.getEncoded())).hexEncode(true).drainToString();
                    if (!digest.equalsIgnoreCase((String)attribute.get(i))) continue;
                    return true;
                }
            }
            catch (NoSuchAlgorithmException | CertificateEncodingException e) {
                throw new RealmUnavailableException(e);
            }
            return false;
        }
    }

    static class SubjectDnCertificateVerifier
    implements CertificateVerifier {
        final String ldapAttribute;

        SubjectDnCertificateVerifier(String ldapAttribute) {
            this.ldapAttribute = ldapAttribute;
        }

        @Override
        public void addRequiredLdapAttributes(Collection<String> requiredAttributes) {
            requiredAttributes.add(this.ldapAttribute);
        }

        @Override
        public boolean verifyCertificate(X509Certificate certificate, Attributes attributes) throws NamingException {
            Attribute attribute = attributes.get(this.ldapAttribute);
            int size = attribute.size();
            for (int i = 0; i < size; ++i) {
                if (!certificate.getSubjectDN().getName().equals(attribute.get(i))) continue;
                return true;
            }
            return false;
        }
    }

    static class SerialNumberCertificateVerifier
    implements CertificateVerifier {
        final String ldapAttribute;

        SerialNumberCertificateVerifier(String ldapAttribute) {
            this.ldapAttribute = ldapAttribute;
        }

        @Override
        public void addRequiredLdapAttributes(Collection<String> requiredAttributes) {
            requiredAttributes.add(this.ldapAttribute);
        }

        @Override
        public boolean verifyCertificate(X509Certificate certificate, Attributes attributes) throws NamingException {
            Attribute attribute = attributes.get(this.ldapAttribute);
            int size = attribute.size();
            for (int i = 0; i < size; ++i) {
                BigInteger value = new BigInteger((String)attribute.get(i));
                if (!certificate.getSerialNumber().equals(value)) continue;
                return true;
            }
            return false;
        }
    }

    static interface CertificateVerifier {
        default public void addRequiredLdapAttributes(Collection<String> requiredAttributes) {
        }

        default public void addBinaryLdapAttributes(Collection<String> binaryAttributes) {
        }

        public boolean verifyCertificate(X509Certificate var1, Attributes var2) throws NamingException, RealmUnavailableException;
    }
}

