/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.entity;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.asn1.DERDecoder;
import org.wildfly.security.asn1.DEREncoder;
import org.wildfly.security.util.ByteStringBuilder;

public abstract class GeneralName {
    public static final int OTHER_NAME = 0;
    public static final int RFC_822_NAME = 1;
    public static final int DNS_NAME = 2;
    public static final int X400_ADDRESS = 3;
    public static final int DIRECTORY_NAME = 4;
    public static final int EDI_PARTY_NAME = 5;
    public static final int URI_NAME = 6;
    public static final int IP_ADDRESS = 7;
    public static final int REGISTERED_ID = 8;
    private final int type;

    GeneralName(int type) {
        if (type < 0 || type > 8) {
            throw ElytronMessages.log.invalidValueForGeneralNameType();
        }
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public abstract Object getName();

    public static final class RegisteredID
    extends GeneralName {
        private final String name;

        public RegisteredID(String name) {
            super(8);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            return obj instanceof RegisteredID && this.equals((RegisteredID)obj);
        }

        public boolean equals(RegisteredID other) {
            return this.name.equals(other.getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static final class IPAddress
    extends GeneralName {
        private final byte[] address;

        public IPAddress(String strAddress) {
            this(IPAddress.parseIPAddress(strAddress));
        }

        public IPAddress(byte[] address) {
            super(7);
            if (address.length != 4 && address.length != 8 && address.length != 16 && address.length != 32) {
                throw ElytronMessages.log.asnInvalidGeneralNameForIpAddressType();
            }
            this.address = address;
        }

        public byte[] getName() {
            return this.address;
        }

        public boolean equals(Object obj) {
            return obj instanceof IPAddress && this.equals((IPAddress)obj);
        }

        public boolean equals(IPAddress other) {
            if (other != null) {
                int length = this.address.length;
                byte[] otherAddress = other.getName();
                int otherLength = otherAddress.length;
                if (length != otherLength) {
                    return false;
                }
                if (length == 8 || length == 32) {
                    int i;
                    int maskLength = length / 2;
                    for (i = 0; i < maskLength; ++i) {
                        byte maskedByte = (byte)(this.address[i] & this.address[i + maskLength]);
                        byte otherMaskedByte = (byte)(otherAddress[i] & otherAddress[i + maskLength]);
                        if (maskedByte == otherMaskedByte) continue;
                        return false;
                    }
                    for (i = 0; i < maskLength; ++i) {
                        if (this.address[i + maskLength] == otherAddress[i + maskLength]) continue;
                        return false;
                    }
                    return true;
                }
                return Arrays.equals(this.address, other.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.address.hashCode();
        }

        private static byte[] parseIPAddress(String strAddress) throws ASN1Exception {
            byte[] addr;
            block4: {
                try {
                    if (strAddress.indexOf(46) >= 0) {
                        addr = IPAddress.parseIPv4Address(strAddress);
                        break block4;
                    }
                    if (strAddress.indexOf(58) >= 0) {
                        addr = IPAddress.parseIPv6Address(strAddress);
                        break block4;
                    }
                    throw ElytronMessages.log.asnInvalidGeneralNameForIpAddressType();
                }
                catch (UnknownHostException e) {
                    throw ElytronMessages.log.asnIpAddressGeneralNameCannotBeResolved(e);
                }
            }
            return addr;
        }

        private static byte[] parseIPv4Address(String strAddress) throws UnknownHostException {
            byte[] addr;
            int slashIndex = strAddress.indexOf(47);
            if (slashIndex == -1) {
                addr = InetAddress.getByName(strAddress).getAddress();
            } else {
                addr = new byte[8];
                byte[] baseAddress = InetAddress.getByName(strAddress.substring(0, slashIndex)).getAddress();
                byte[] mask = InetAddress.getByName(strAddress.substring(slashIndex + 1)).getAddress();
                System.arraycopy(baseAddress, 0, addr, 0, 4);
                System.arraycopy(mask, 0, addr, 4, 4);
            }
            return addr;
        }

        private static byte[] parseIPv6Address(String strAddress) throws ASN1Exception, UnknownHostException {
            byte[] addr;
            int slashIndex = strAddress.indexOf(47);
            if (slashIndex == -1) {
                addr = InetAddress.getByName(strAddress).getAddress();
            } else {
                addr = new byte[32];
                byte[] baseAddress = InetAddress.getByName(strAddress.substring(0, slashIndex)).getAddress();
                System.arraycopy(baseAddress, 0, addr, 0, 16);
                int prefixLength = Integer.parseInt(strAddress.substring(slashIndex + 1));
                if (prefixLength > 128) {
                    throw ElytronMessages.log.asnInvalidGeneralNameForIpAddressType();
                }
                byte[] mask = new byte[16];
                for (int i = 0; i < prefixLength; ++i) {
                    int maskIndex = i / 8;
                    int bit = 1 << 7 - i % 8;
                    int n = maskIndex;
                    mask[n] = (byte)(mask[n] | bit);
                }
                System.arraycopy(mask, 0, addr, 16, 16);
            }
            return addr;
        }
    }

    public static final class URIName
    extends GeneralName {
        private final String name;

        public URIName(String name) {
            super(6);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            return obj instanceof URIName && this.equals((URIName)obj);
        }

        public boolean equals(URIName other) {
            try {
                return new URI(this.name).equals(new URI(other.getName()));
            }
            catch (URISyntaxException e) {
                throw ElytronMessages.log.asnInvalidGeneralNameForUriType(e);
            }
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static final class EDIPartyName
    extends GeneralName {
        private final byte[] encodedName;

        public EDIPartyName(byte[] encodedName) throws ASN1Exception {
            this(encodedName, false);
        }

        public EDIPartyName(byte[] encoded, boolean valueBytesOnly) throws ASN1Exception {
            super(5);
            if (valueBytesOnly) {
                ByteStringBuilder generalName = new ByteStringBuilder();
                DEREncoder encoder = new DEREncoder(generalName);
                encoder.startSequence();
                encoder.writeEncoded(encoded);
                encoder.endSequence();
                this.encodedName = generalName.toArray();
            } else {
                this.encodedName = encoded;
            }
        }

        public byte[] getName() {
            return (byte[])this.encodedName.clone();
        }

        public boolean equals(Object obj) {
            return obj instanceof EDIPartyName && this.equals((EDIPartyName)obj);
        }

        public boolean equals(EDIPartyName other) {
            return other != null && Arrays.equals(this.encodedName, other.getName());
        }

        public int hashCode() {
            return Arrays.hashCode(this.encodedName);
        }
    }

    public static final class DirectoryName
    extends GeneralName {
        private final String name;

        public DirectoryName(String name) {
            super(4);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            return obj instanceof DirectoryName && this.equals((DirectoryName)obj);
        }

        public boolean equals(DirectoryName other) {
            return new X500Principal(this.name).equals(new X500Principal(other.getName()));
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static final class X400Address
    extends GeneralName {
        private final byte[] encodedName;

        public X400Address(byte[] encodedName) throws ASN1Exception {
            this(encodedName, false);
        }

        public X400Address(byte[] encoded, boolean valueBytesOnly) throws ASN1Exception {
            super(3);
            if (valueBytesOnly) {
                ByteStringBuilder generalName = new ByteStringBuilder();
                DEREncoder encoder = new DEREncoder(generalName);
                encoder.startSequence();
                encoder.writeEncoded(encoded);
                encoder.endSequence();
                this.encodedName = generalName.toArray();
            } else {
                this.encodedName = encoded;
            }
        }

        public byte[] getName() {
            return (byte[])this.encodedName.clone();
        }

        public boolean equals(Object obj) {
            return obj instanceof X400Address && this.equals((X400Address)obj);
        }

        public boolean equals(X400Address other) {
            return other != null && Arrays.equals(this.encodedName, other.getName());
        }

        public int hashCode() {
            return Arrays.hashCode(this.encodedName);
        }
    }

    public static final class DNSName
    extends GeneralName {
        private final String name;

        public DNSName(String name) {
            super(2);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            return obj instanceof DNSName && this.equals((DNSName)obj);
        }

        public boolean equals(DNSName other) {
            return other != null && this.name.equalsIgnoreCase(other.getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static final class RFC822Name
    extends GeneralName {
        private final String name;

        public RFC822Name(String name) {
            super(1);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            return obj instanceof RFC822Name && this.equals((RFC822Name)obj);
        }

        public boolean equals(RFC822Name other) {
            return other != null && this.name.equalsIgnoreCase(other.getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static final class OtherName
    extends GeneralName {
        private final byte[] encodedName;
        private final String typeId;
        private final byte[] encodedValue;

        public OtherName(byte[] encodedName) throws ASN1Exception {
            super(0);
            this.encodedName = encodedName;
            DERDecoder decoder = new DERDecoder(encodedName);
            decoder.startSequence();
            this.typeId = decoder.decodeObjectIdentifier();
            this.encodedValue = decoder.drainElement();
            decoder.endSequence();
        }

        public OtherName(String typeId, byte[] encodedValue) throws ASN1Exception {
            super(0);
            this.typeId = typeId;
            this.encodedValue = encodedValue;
            ByteStringBuilder generalName = new ByteStringBuilder();
            DEREncoder encoder = new DEREncoder(generalName);
            encoder.startSequence();
            encoder.encodeObjectIdentifier(typeId);
            encoder.writeEncoded(encodedValue);
            encoder.endSequence();
            this.encodedName = generalName.toArray();
        }

        public byte[] getName() {
            return (byte[])this.encodedName.clone();
        }

        public String getObjectIdentifier() {
            return this.typeId;
        }

        public byte[] getEncodedValue() {
            return (byte[])this.encodedValue.clone();
        }

        public boolean equals(Object obj) {
            return obj instanceof OtherName && this.equals((OtherName)obj);
        }

        public boolean equals(OtherName other) {
            return other != null && Arrays.equals(this.encodedName, other.getName());
        }

        public int hashCode() {
            return Arrays.hashCode(this.encodedName);
        }
    }
}

