/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Principal;
import org.wildfly.common.Assert;
import org.wildfly.security.evidence.Evidence;

public interface EvidenceDecoder {
    public Principal getPrincipalFromEvidence(Evidence var1);

    public static EvidenceDecoder aggregate(EvidenceDecoder ... decoders) {
        Assert.checkNotNullParam((String)"decoders", (Object)decoders);
        return evidence -> {
            for (EvidenceDecoder decoder : decoders) {
                Principal result = decoder.getPrincipalFromEvidence(evidence);
                if (result == null) continue;
                return result;
            }
            return null;
        };
    }
}

