/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider;

import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.provider.SimpleRealmEntry;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.password.Password;

public class SimpleMapBackedSecurityRealm
implements SecurityRealm {
    private final NameRewriter rewriter;
    private volatile Map<String, SimpleRealmEntry> map = Collections.emptyMap();

    public SimpleMapBackedSecurityRealm(NameRewriter rewriter) {
        Assert.checkNotNullParam((String)"rewriter", (Object)rewriter);
        this.rewriter = rewriter;
    }

    public SimpleMapBackedSecurityRealm() {
        this(NameRewriter.IDENTITY_REWRITER);
    }

    public void setPasswordMap(Map<String, SimpleRealmEntry> map) {
        Assert.checkNotNullParam((String)"map", map);
        this.map = map;
    }

    public void setPasswordMap(String name, Password password, Attributes attributes) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"password", (Object)password);
        Assert.checkNotNullParam((String)"attributes", (Object)attributes);
        this.map = Collections.singletonMap(name, new SimpleRealmEntry(Collections.singletonList(new PasswordCredential(password)), attributes));
    }

    public void setPasswordMap(String name, Password password) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"password", (Object)password);
        this.map = Collections.singletonMap(name, new SimpleRealmEntry(Collections.singletonList(new PasswordCredential(password))));
    }

    @Override
    public RealmIdentity getRealmIdentity(String name, Principal principal, Evidence evidence) {
        if (name == null) {
            return RealmIdentity.NON_EXISTENT;
        }
        if ((name = this.rewriter.rewriteName(name)) == null) {
            throw ElytronMessages.log.invalidName();
        }
        return new SimpleMapRealmIdentity(name);
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"evidenceType", evidenceType);
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    private class SimpleMapRealmIdentity
    implements RealmIdentity {
        private final String name;

        SimpleMapRealmIdentity(String name) {
            this.name = name;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            SimpleRealmEntry entry = (SimpleRealmEntry)SimpleMapBackedSecurityRealm.this.map.get(this.name);
            if (entry == null) {
                return SupportLevel.UNSUPPORTED;
            }
            for (Credential credential : entry.getCredentials()) {
                if (!credentialType.isInstance(credential) || algorithmName != null && (!(credential instanceof AlgorithmCredential) || !algorithmName.equals(((AlgorithmCredential)credential).getAlgorithm()))) continue;
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.getCredential(credentialType, null);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            SimpleRealmEntry entry = (SimpleRealmEntry)SimpleMapBackedSecurityRealm.this.map.get(this.name);
            if (entry == null) {
                return null;
            }
            for (Credential credential : entry.getCredentials()) {
                if (!credentialType.isInstance(credential) || algorithmName != null && (!(credential instanceof AlgorithmCredential) || !algorithmName.equals(((AlgorithmCredential)credential).getAlgorithm()))) continue;
                return (C)((Credential)credentialType.cast(credential));
            }
            return null;
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() {
            SimpleRealmEntry entry = (SimpleRealmEntry)SimpleMapBackedSecurityRealm.this.map.get(this.name);
            return entry == null ? AuthorizationIdentity.EMPTY : AuthorizationIdentity.basicIdentity(entry.getAttributes());
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidenceType", evidenceType);
            SimpleRealmEntry entry = (SimpleRealmEntry)SimpleMapBackedSecurityRealm.this.map.get(this.name);
            if (entry == null) {
                return SupportLevel.UNSUPPORTED;
            }
            for (Credential credential : entry.getCredentials()) {
                if (!credential.canVerify(evidenceType, algorithmName)) continue;
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidence", (Object)evidence);
            SimpleRealmEntry entry = (SimpleRealmEntry)SimpleMapBackedSecurityRealm.this.map.get(this.name);
            if (entry == null) {
                return false;
            }
            for (Credential credential : entry.getCredentials()) {
                if (!credential.canVerify(evidence)) continue;
                return credential.verify(evidence);
            }
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return SimpleMapBackedSecurityRealm.this.map.containsKey(this.name);
        }
    }
}

