/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.callback;

import java.io.Serializable;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.ExtendedCallback;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;

public final class CredentialCallback
implements ExtendedCallback,
Serializable {
    private static final long serialVersionUID = 4756568346009259703L;
    private final Class<? extends Credential> credentialType;
    private final String algorithm;
    private Credential credential;

    public CredentialCallback(Class<? extends Credential> credentialType, String algorithm) {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        this.credentialType = credentialType;
        this.algorithm = algorithm;
    }

    public CredentialCallback(Class<? extends Credential> credentialType) {
        this(credentialType, null);
    }

    public Credential getCredential() {
        return this.credential;
    }

    public void setCredential(Credential credential) {
        if (credential != null && !this.isCredentialSupported(credential)) {
            throw ElytronMessages.log.credentialNotSupported();
        }
        this.credential = credential;
    }

    public boolean isCredentialTypeSupported(Class<? extends Credential> credentialType) {
        return this.isCredentialTypeSupported(credentialType, null);
    }

    public boolean isCredentialTypeSupported(Class<? extends Credential> credentialType, String algorithmName) {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return this.credentialType.isAssignableFrom(credentialType) && (this.algorithm == null || AlgorithmCredential.class.isAssignableFrom(credentialType) && this.algorithm.equals(algorithmName));
    }

    public boolean isCredentialSupported(Credential credential) {
        Assert.checkNotNullParam((String)"credential", (Object)credential);
        return this.credentialType.isInstance(credential) && (this.algorithm == null || credential instanceof AlgorithmCredential && this.algorithm.equals(((AlgorithmCredential)credential).getAlgorithm()));
    }

    public Class<? extends Credential> getCredentialType() {
        return this.credentialType;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public boolean isOptional() {
        return this.credential != null;
    }

    @Override
    public boolean needsInformation() {
        return true;
    }
}

