/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.scram;

import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism.scram.ScramClient;
import org.wildfly.security.mechanism.scram.ScramFinalClientMessage;
import org.wildfly.security.mechanism.scram.ScramFinalServerMessage;
import org.wildfly.security.mechanism.scram.ScramInitialClientMessage;
import org.wildfly.security.mechanism.scram.ScramInitialServerMessage;
import org.wildfly.security.sasl.util.AbstractSaslClient;

class ScramSaslClient
extends AbstractSaslClient {
    private static final int ST_NEW = 1;
    private static final int ST_R1_SENT = 2;
    private static final int ST_R2_SENT = 3;
    private final ScramClient scramClient;
    private ScramInitialClientMessage initialResponse;
    private ScramFinalClientMessage finalResponse;

    ScramSaslClient(String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler, String authorizationId, ScramClient scramClient) {
        super(mechanismName, protocol, serverName, callbackHandler, authorizationId, true);
        this.scramClient = scramClient;
        this.setNegotiationState(1);
    }

    @Override
    public void dispose() throws SaslException {
        this.initialResponse = null;
        this.finalResponse = null;
        this.setNegotiationState(-1);
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] challenge) throws SaslException {
        boolean ok = false;
        try {
            switch (state) {
                case 1: {
                    if (challenge.length != 0) {
                        throw ElytronMessages.log.mechInitialChallengeMustBeEmpty(this.getMechanismName()).toSaslException();
                    }
                    this.initialResponse = this.scramClient.getInitialResponse();
                    this.setNegotiationState(2);
                    ok = true;
                    byte[] byArray = this.initialResponse.getMessageBytes();
                    return byArray;
                }
                case 2: {
                    ScramInitialServerMessage initialChallenge = this.scramClient.parseInitialServerMessage(this.initialResponse, challenge);
                    this.finalResponse = this.scramClient.handleInitialChallenge(this.initialResponse, initialChallenge);
                    this.setNegotiationState(3);
                    ok = true;
                    byte[] byArray = this.finalResponse.getMessageBytes();
                    return byArray;
                }
                case 3: {
                    ScramFinalServerMessage finalChallenge = this.scramClient.parseFinalServerMessage(challenge);
                    this.scramClient.verifyFinalChallenge(this.finalResponse, finalChallenge);
                    this.setNegotiationState(0);
                    ok = true;
                    byte[] byArray = null;
                    return byArray;
                }
            }
            try {
                throw Assert.impossibleSwitchCase((int)state);
            }
            catch (AuthenticationMechanismException e) {
                throw e.toSaslException();
            }
        }
        finally {
            if (!ok) {
                this.setNegotiationState(-1);
            }
        }
    }
}

