/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.entity;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.sasl.entity.EntitySaslServer;

public final class EntitySaslServerFactory
implements SaslServerFactory {
    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        Signature signature;
        boolean mutual = false;
        boolean serverAuth = Boolean.parseBoolean(String.valueOf(props.get("javax.security.sasl.server.authentication")));
        switch (mechanism) {
            case "9798-M-RSA-SHA1-ENC": {
                mutual = true;
            }
            case "9798-U-RSA-SHA1-ENC": {
                if (serverAuth && !mutual) {
                    return null;
                }
                try {
                    signature = Signature.getInstance("SHA1withRSA");
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    return null;
                }
            }
            case "9798-M-DSA-SHA1": {
                mutual = true;
            }
            case "9798-U-DSA-SHA1": {
                if (serverAuth && !mutual) {
                    return null;
                }
                try {
                    signature = Signature.getInstance("SHA1withDSA");
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    return null;
                }
            }
            case "9798-M-ECDSA-SHA1": {
                mutual = true;
            }
            case "9798-U-ECDSA-SHA1": {
                if (serverAuth && !mutual) {
                    return null;
                }
                try {
                    signature = Signature.getInstance("SHA1withECDSA");
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    return null;
                }
            }
            default: {
                return null;
            }
        }
        Object rngNameValue = props.get("wildfly.sasl.secure-rng");
        String rngName = rngNameValue instanceof String ? (String)rngNameValue : null;
        SecureRandom secureRandom = null;
        if (rngName != null) {
            try {
                secureRandom = SecureRandom.getInstance(rngName);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        EntitySaslServer server = new EntitySaslServer(mechanism, protocol, serverName, cbh, props, mutual, signature, secureRandom);
        server.init();
        return server;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        if (!"true".equals(props.get("wildfly.sasl.mechanism-query-all")) && "true".equals(props.get("javax.security.sasl.server.authentication"))) {
            return new String[]{"9798-M-RSA-SHA1-ENC", "9798-M-DSA-SHA1", "9798-M-ECDSA-SHA1"};
        }
        return new String[]{"9798-U-RSA-SHA1-ENC", "9798-M-RSA-SHA1-ENC", "9798-U-DSA-SHA1", "9798-M-DSA-SHA1", "9798-U-ECDSA-SHA1", "9798-M-ECDSA-SHA1"};
    }
}

