/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.evidence;

import java.security.cert.X509Certificate;
import org.wildfly.common.Assert;
import org.wildfly.security.evidence.AlgorithmEvidence;

public final class X509PeerCertificateChainEvidence
implements AlgorithmEvidence {
    private final X509Certificate[] peerCertificateChain;

    public X509PeerCertificateChainEvidence(X509Certificate ... peerCertificateChain) {
        Assert.checkNotNullParam((String)"peerCertificateChain", (Object)peerCertificateChain);
        this.peerCertificateChain = peerCertificateChain;
    }

    public X509Certificate[] getPeerCertificateChain() {
        return this.peerCertificateChain;
    }

    @Override
    public String getAlgorithm() {
        return this.getFirstCertificate().getPublicKey().getAlgorithm();
    }

    public X509Certificate getFirstCertificate() {
        return this.peerCertificateChain[0];
    }

    public X509Certificate getLastCertificate() {
        return this.peerCertificateChain[this.peerCertificateChain.length - 1];
    }
}

