/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.security.GeneralSecurityException;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.ConfigurationKeyManager;
import org.wildfly.security.auth.client.SSLClientKeyManagerConfiguration;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;

class SSLClientCertificateConfiguration
extends AuthenticationConfiguration {
    private final SecurityFactory<X509CertificateChainPrivateCredential> credentialFactory;

    SSLClientCertificateConfiguration(AuthenticationConfiguration parent, SecurityFactory<X509CertificateChainPrivateCredential> credentialFactory) {
        super(parent.without(SSLClientKeyManagerConfiguration.class), true);
        this.credentialFactory = credentialFactory;
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SSLClientCertificateConfiguration(newParent, this.credentialFactory);
    }

    @Override
    void configureKeyManager(ConfigurationKeyManager.Builder builder) throws GeneralSecurityException {
        super.configureKeyManager(builder);
        builder.addCredential(this.credentialFactory.create());
    }
}

