/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.x500.X500PrincipalUtil;

final class ConfigurationKeyManager
extends X509ExtendedKeyManager {
    private final Map<String, Map<X500Principal, String>> credentialAliasesByKeyTypeAndIssuer;
    private final Map<String, X509CertificateChainPrivateCredential> credentialsByAlias;

    ConfigurationKeyManager(Map<String, Map<X500Principal, String>> credentialAliasesByKeyTypeAndIssuer, Map<String, X509CertificateChainPrivateCredential> credentialsByAlias) {
        this.credentialAliasesByKeyTypeAndIssuer = credentialAliasesByKeyTypeAndIssuer;
        this.credentialsByAlias = credentialsByAlias;
    }

    private String getCredentialAlias(String keyType, Principal[] issuers) {
        Map<X500Principal, String> aliasesByIssuer = this.credentialAliasesByKeyTypeAndIssuer.get(keyType);
        if (aliasesByIssuer != null) {
            if (issuers != null) {
                for (Principal issuer : issuers) {
                    X500Principal x500Principal = X500PrincipalUtil.asX500Principal(issuer);
                    String alias = aliasesByIssuer.get(x500Principal);
                    if (alias == null) continue;
                    return alias;
                }
            } else {
                Iterator<String> iterator = aliasesByIssuer.values().iterator();
                if (iterator.hasNext()) {
                    return iterator.next();
                }
            }
        }
        return null;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        LinkedHashSet<String> aliases;
        block6: {
            Map<X500Principal, String> aliasesByIssuer = this.credentialAliasesByKeyTypeAndIssuer.get(keyType);
            aliases = null;
            if (aliasesByIssuer == null) break block6;
            if (issuers != null) {
                for (Principal issuer : issuers) {
                    X500Principal x500Principal = X500PrincipalUtil.asX500Principal(issuer);
                    String alias = aliasesByIssuer.get(x500Principal);
                    if (alias == null) continue;
                    if (aliases == null) {
                        aliases = new LinkedHashSet(3);
                    }
                    aliases.add(alias);
                }
            } else {
                for (String alias : aliasesByIssuer.values()) {
                    if (alias == null) continue;
                    if (aliases == null) {
                        aliases = new LinkedHashSet<String>(3);
                    }
                    aliases.add(alias);
                }
            }
        }
        return aliases == null ? null : aliases.toArray(new String[aliases.size()]);
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        for (String keyType : keyTypes) {
            String alias = this.getCredentialAlias(keyType, issuers);
            if (alias == null) continue;
            return alias;
        }
        return null;
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine sslEngine) {
        for (String keyType : keyTypes) {
            String alias = this.getCredentialAlias(keyType, issuers);
            if (alias == null) continue;
            return alias;
        }
        return null;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String chooseEngineServerAlias(String KeyType, Principal[] issuers, SSLEngine sslEngine) {
        throw new UnsupportedOperationException();
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        X509CertificateChainPrivateCredential credential = this.credentialsByAlias.get(alias);
        return credential == null ? null : credential.getCertificateChain();
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        X509CertificateChainPrivateCredential credential = this.credentialsByAlias.get(alias);
        return credential == null ? null : credential.getPrivateKey();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private final Map<String, Map<X500Principal, String>> credentialAliasesByKeyTypeAndIssuer = new HashMap<String, Map<X500Principal, String>>();
        private final Map<String, X509CertificateChainPrivateCredential> credentialsByAlias = new HashMap<String, X509CertificateChainPrivateCredential>();

        Builder() {
        }

        void addCredential(X509CertificateChainPrivateCredential credential) {
            String alias;
            PrivateKey privateKey = credential.getPrivateKey();
            X509Certificate[] certificateChain = credential.getCertificateChain();
            String keyType = privateKey.getAlgorithm();
            while (this.credentialsByAlias.containsKey(alias = this.randomString())) {
            }
            this.credentialsByAlias.put(alias, credential);
            Map<X500Principal, String> aliasesByIssuer = this.credentialAliasesByKeyTypeAndIssuer.get(keyType);
            if (aliasesByIssuer == null) {
                aliasesByIssuer = new HashMap<X500Principal, String>(1);
                this.credentialAliasesByKeyTypeAndIssuer.put(keyType, aliasesByIssuer);
            }
            for (X509Certificate certificate : certificateChain) {
                X500Principal principal = certificate.getIssuerX500Principal();
                aliasesByIssuer.put(principal, alias);
            }
        }

        private String randomString() {
            char[] c = new char[12];
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (int i = 0; i < c.length; ++i) {
                int r = random.nextInt() & 0x3F;
                c[i] = (char)(r < 26 ? 65 + r : (r < 52 ? 97 + r - 26 : (r == 62 ? 43 : 95)));
            }
            return new String(c);
        }

        ConfigurationKeyManager build() {
            return new ConfigurationKeyManager(this.credentialAliasesByKeyTypeAndIssuer, this.credentialsByAlias);
        }
    }
}

