/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import org.wildfly.common.Assert;
import org.wildfly.security.permission.AbstractNameSetOnlyPermission;
import org.wildfly.security.util.StringEnumeration;
import org.wildfly.security.util.StringMapping;

public final class ElytronPermission
extends AbstractNameSetOnlyPermission<ElytronPermission> {
    private static final long serialVersionUID = 6124294238228442419L;
    private static final StringEnumeration strings = StringEnumeration.of("authenticate", "createAuthenticator", "createAuthenticationContextConfigurationClient", "createSecurityDomain", "registerSecurityDomain", "getSecurityDomain", "unregisterSecurityDomain", "setRunAsPrincipal", "createServerAuthenticationContext", "getPrivateCredentials", "getIdentity", "getIdentityForUpdate", "createAdHocIdentity");
    static final StringMapping<ElytronPermission> mapping = new StringMapping<ElytronPermission>(strings, ElytronPermission::new);
    private static final ElytronPermission allPermission = new ElytronPermission("*");

    public ElytronPermission(String name) {
        this(name, (String)null);
    }

    public ElytronPermission(String name, String actions) {
        super(name, strings);
        ElytronPermission.requireEmptyActions(actions);
    }

    @Override
    public ElytronPermission withName(String name) {
        return ElytronPermission.forName(name);
    }

    public static ElytronPermission forName(String name) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return name.equals("*") ? allPermission : mapping.getItemByString(name);
    }
}

