/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.interfaces.ClearPassword;

class SetForwardAuthenticationConfiguration
extends AuthenticationConfiguration
implements AuthenticationConfiguration.UserSetting,
AuthenticationConfiguration.CredentialSetting {
    private final SecurityDomain sourceDomain;
    private final AccessControlContext context;

    SetForwardAuthenticationConfiguration(AuthenticationConfiguration parent, SecurityDomain sourceDomain, AccessControlContext context) {
        super(parent.without(AuthenticationConfiguration.UserSetting.class, AuthenticationConfiguration.CredentialSetting.class, SetCallbackHandlerAuthenticationConfiguration.class));
        this.sourceDomain = sourceDomain;
        this.context = context;
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws UnsupportedCallbackException, IOException {
        Callback callback = callbacks[index];
        SecurityIdentity identity = this.sourceDomain.getCurrentSecurityIdentity();
        if (!identity.isAnonymous()) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.doRewriteUser(identity.getPrincipal().getName()));
            } else if (callback instanceof CredentialCallback) {
                CredentialCallback credentialCallback = (CredentialCallback)callback;
                Class<? extends Credential> credentialType = credentialCallback.getCredentialType();
                String algorithm = credentialCallback.getAlgorithm();
                AlgorithmParameterSpec parameterSpec = credentialCallback.getParameterSpec();
                IdentityCredentials privateCredentials = this.getPrivateCredentials(identity, this.context);
                Credential credential = privateCredentials.getCredential(credentialType, algorithm, parameterSpec);
                if (credential != null) {
                    credentialCallback.setCredential(credential);
                }
            } else if (callback instanceof PasswordCallback) {
                ClearPassword clearPassword;
                IdentityCredentials privateCredentials = this.getPrivateCredentials(identity, this.context);
                PasswordCredential credential = privateCredentials.getCredential(PasswordCredential.class, "clear");
                if (credential != null && (clearPassword = credential.getPassword(ClearPassword.class)) != null) {
                    ((PasswordCallback)callback).setPassword(clearPassword.getPassword());
                }
            } else {
                super.handleCallback(callbacks, index);
            }
        }
    }

    private IdentityCredentials getPrivateCredentials(SecurityIdentity identity, AccessControlContext context) {
        return AccessController.doPrivileged(identity::getPrivateCredentials, context);
    }

    @Override
    boolean saslSupportedByConfiguration(String mechanismName) {
        return this.sourceDomain.getCurrentSecurityIdentity().isAnonymous() && "ANONYMOUS".equals(mechanismName) || super.saslSupportedByConfiguration(mechanismName);
    }

    @Override
    Principal getPrincipal() {
        return this.sourceDomain.getCurrentSecurityIdentity().getPrincipal();
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetForwardAuthenticationConfiguration(newParent, this.sourceDomain, this.context);
    }

    @Override
    boolean halfEqual(AuthenticationConfiguration other) {
        return Objects.equals(this.sourceDomain, other.getForwardSecurityDomain()) && Objects.equals(this.context, other.getForwardAccessControlContext()) && this.parentHalfEqual(other);
    }

    @Override
    SecurityDomain getForwardSecurityDomain() {
        return this.sourceDomain;
    }

    @Override
    AccessControlContext getForwardAccessControlContext() {
        return this.context;
    }

    @Override
    int calcHashCode() {
        return HashMath.multiHashUnordered((int)HashMath.multiHashUnordered((int)this.parentHashCode(), (int)2551, (int)Objects.hashCode(this.sourceDomain)), (int)2113, (int)Objects.hashCode(this.context));
    }

    @Override
    StringBuilder asString(StringBuilder sb) {
        return this.parentAsString(sb).append("ForwardAuthentication,");
    }
}

