/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.security.Permission;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.event.SecurityDefiniteOutcomeEvent;
import org.wildfly.security.auth.server.event.SecurityEvent;
import org.wildfly.security.auth.server.event.SecurityEventVisitor;
import org.wildfly.security.auth.server.event.SecurityPermissionCheckEvent;

public class SimpleSecurityEventFormatter
extends SecurityEventVisitor<Void, String> {
    private final Supplier<DateFormat> dateFormatSupplier;

    SimpleSecurityEventFormatter(Builder builder) {
        this.dateFormatSupplier = builder.dateFormatSupplier;
    }

    @Override
    public String handleUnknownEvent(SecurityEvent event, Void param) {
        Assert.checkNotNullParam((String)"event", (Object)event);
        StringBuilder stringBuilder = new StringBuilder(123);
        this.handleUnknownEvent(event, stringBuilder);
        return stringBuilder.append('}').toString();
    }

    @Override
    private void handleUnknownEvent(SecurityEvent event, StringBuilder stringBuilder) {
        DateFormat dateFormat = this.dateFormatSupplier.get();
        stringBuilder.append("event=").append(event.getClass().getSimpleName());
        stringBuilder.append(",event-time=").append(dateFormat.format(Date.from(event.getInstant())));
        SecurityIdentity securityIdentity = event.getSecurityIdentity();
        stringBuilder.append(",security-identity=[name=").append(securityIdentity.getPrincipal().getName());
        stringBuilder.append(",creation-time=").append(dateFormat.format(Date.from(securityIdentity.getCreationTime()))).append(']');
    }

    @Override
    public String handleDefiniteOutcomeEvent(SecurityDefiniteOutcomeEvent event, Void param) {
        Assert.checkNotNullParam((String)"event", (Object)event);
        StringBuilder stringBuilder = new StringBuilder(123);
        this.handleDefiniteOutcomeEvent(event, stringBuilder);
        return stringBuilder.append('}').toString();
    }

    @Override
    private void handleDefiniteOutcomeEvent(SecurityDefiniteOutcomeEvent event, StringBuilder stringBuilder) {
        this.handleUnknownEvent((SecurityEvent)event, stringBuilder);
        stringBuilder.append(",success=").append(event.isSuccessful());
    }

    @Override
    public String handlePermissionCheckEvent(SecurityPermissionCheckEvent event, Void param) {
        Assert.checkNotNullParam((String)"event", (Object)event);
        StringBuilder stringBuilder = new StringBuilder(123);
        this.handlePermissionCheckEvent(event, stringBuilder);
        return stringBuilder.append('}').toString();
    }

    @Override
    private void handlePermissionCheckEvent(SecurityPermissionCheckEvent event, StringBuilder stringBuilder) {
        this.handleDefiniteOutcomeEvent((SecurityDefiniteOutcomeEvent)event, stringBuilder);
        Permission permission = event.getPermission();
        stringBuilder.append(",permission=[type=").append(permission.getClass().getName());
        stringBuilder.append(",actions=").append(permission.getActions());
        stringBuilder.append(",name=").append(permission.getName()).append(']');
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Supplier<DateFormat> dateFormatSupplier = SimpleDateFormat::new;

        Builder() {
        }

        public Builder setDateFormatSupplier(Supplier<DateFormat> dateFormatSupplier) {
            this.dateFormatSupplier = (Supplier)Assert.checkNotNullParam((String)"dateFormatSupplier", dateFormatSupplier);
            return this;
        }

        public SecurityEventVisitor<Void, String> build() {
            return new SimpleSecurityEventFormatter(this);
        }
    }
}

