/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.util.Objects;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

class SetHostAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final String hostName;

    SetHostAuthenticationConfiguration(AuthenticationConfiguration parent, String hostName) {
        super(parent);
        this.hostName = hostName;
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetHostAuthenticationConfiguration(newParent, this.hostName);
    }

    @Override
    String getHost() {
        return this.hostName;
    }

    @Override
    boolean halfEqual(AuthenticationConfiguration other) {
        return Objects.equals(this.hostName, this.getHost()) && this.parentHalfEqual(other);
    }

    @Override
    int calcHashCode() {
        return HashMath.multiHashUnordered((int)this.parentHashCode(), (int)1553, (int)this.hostName.hashCode());
    }

    @Override
    StringBuilder asString(StringBuilder sb) {
        return this.parentAsString(sb).append("host=").append(this.hostName).append(',');
    }
}

