/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.util.Objects;
import java.util.Set;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

class FilterSaslMechanismAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final Set<String> allowed;
    private final Set<String> denied;

    FilterSaslMechanismAuthenticationConfiguration(AuthenticationConfiguration parent, Set<String> allowed, Set<String> denied) {
        super(parent);
        this.allowed = allowed;
        this.denied = denied;
    }

    @Override
    boolean saslSupportedByConfiguration(String mechanismName) {
        return this.allowed.contains(mechanismName) || super.saslSupportedByConfiguration(mechanismName);
    }

    @Override
    boolean saslAllowedByConfiguration(String mechanismName) {
        return !this.denied.contains(mechanismName) && super.saslAllowedByConfiguration(mechanismName);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new FilterSaslMechanismAuthenticationConfiguration(newParent, this.allowed, this.denied);
    }

    @Override
    StringBuilder asString(StringBuilder sb) {
        this.parentAsString(sb);
        sb.append("FilterSaslMechanism ");
        boolean deniedEmpty = this.denied.isEmpty();
        if (!this.allowed.isEmpty()) {
            sb.append("allowed=").append(this.allowed).append(deniedEmpty ? (char)',' : ' ');
        }
        if (!deniedEmpty) {
            sb.append("denied=").append(this.denied).append(',');
        }
        return sb;
    }

    @Override
    Set<String> getAllowedSaslMechanisms() {
        return this.allowed;
    }

    @Override
    Set<String> getDeniedSaslMechanisms() {
        return this.denied;
    }

    @Override
    boolean halfEqual(AuthenticationConfiguration other) {
        return Objects.equals(this.allowed, other.getAllowedSaslMechanisms()) && Objects.equals(this.denied, other.getDeniedSaslMechanisms()) && this.parentHalfEqual(other);
    }

    @Override
    int calcHashCode() {
        return HashMath.multiHashUnordered((int)HashMath.multiHashUnordered((int)this.parentHashCode(), (int)5393, (int)Objects.hashCode(this.denied)), (int)3719, (int)Objects.hashCode(this.allowed));
    }
}

