/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Principal;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.NameRewriter;

public interface PrincipalDecoder {
    public static final PrincipalDecoder DEFAULT = Principal::getName;

    public String getName(Principal var1);

    default public PrincipalDecoder withRewriter(NameRewriter nameRewriter) {
        return principal -> {
            String name = this.getName(principal);
            return name == null ? null : nameRewriter.rewriteName(name);
        };
    }

    public static PrincipalDecoder aggregate(PrincipalDecoder ... decoders) {
        Assert.checkNotNullParam((String)"decoders", (Object)decoders);
        return principal -> {
            for (PrincipalDecoder decoder : decoders) {
                String result = decoder.getName(principal);
                if (result == null) continue;
                return result;
            }
            return null;
        };
    }

    public static PrincipalDecoder concatenating(PrincipalDecoder former, String joinString, PrincipalDecoder latter) {
        Assert.checkNotNullParam((String)"former", (Object)former);
        Assert.checkNotNullParam((String)"joinString", (Object)joinString);
        Assert.checkNotNullParam((String)"latter", (Object)latter);
        return principal -> {
            String formerName = former.getName(principal);
            String latterName = latter.getName(principal);
            if (formerName == null || latterName == null) {
                return null;
            }
            return formerName + joinString + latterName;
        };
    }
}

