/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.NameRewriter;

public final class MechanismRealmConfiguration {
    private final String realmName;
    private final NameRewriter preRealmRewriter;
    private final NameRewriter postRealmRewriter;
    private final NameRewriter finalRewriter;
    public static final MechanismRealmConfiguration NO_REALM = new MechanismRealmConfiguration("none", NameRewriter.IDENTITY_REWRITER, NameRewriter.IDENTITY_REWRITER, NameRewriter.IDENTITY_REWRITER);

    MechanismRealmConfiguration(String realmName, NameRewriter preRealmRewriter, NameRewriter postRealmRewriter, NameRewriter finalRewriter) {
        this.realmName = realmName;
        this.preRealmRewriter = preRealmRewriter;
        this.postRealmRewriter = postRealmRewriter;
        this.finalRewriter = finalRewriter;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public NameRewriter getPreRealmRewriter() {
        return this.preRealmRewriter;
    }

    public NameRewriter getPostRealmRewriter() {
        return this.postRealmRewriter;
    }

    public NameRewriter getFinalRewriter() {
        return this.finalRewriter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String realmName;
        private NameRewriter preRealmRewriter = NameRewriter.IDENTITY_REWRITER;
        private NameRewriter postRealmRewriter = NameRewriter.IDENTITY_REWRITER;
        private NameRewriter finalRewriter = NameRewriter.IDENTITY_REWRITER;

        Builder() {
        }

        public Builder setRealmName(String realmName) {
            this.realmName = realmName;
            return this;
        }

        public Builder setPreRealmRewriter(NameRewriter preRealmRewriter) {
            this.preRealmRewriter = preRealmRewriter;
            return this;
        }

        public Builder setPostRealmRewriter(NameRewriter postRealmRewriter) {
            this.postRealmRewriter = postRealmRewriter;
            return this;
        }

        public Builder setFinalRewriter(NameRewriter finalRewriter) {
            this.finalRewriter = finalRewriter;
            return this;
        }

        public MechanismRealmConfiguration build() {
            Assert.checkNotNullParam((String)"realmName", (Object)this.realmName);
            return new MechanismRealmConfiguration(this.realmName, this.preRealmRewriter, this.postRealmRewriter, this.finalRewriter);
        }
    }
}

