/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.common.Assert;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.credential.Credential;

public final class MechanismConfiguration {
    private final NameRewriter preRealmRewriter;
    private final NameRewriter postRealmRewriter;
    private final NameRewriter finalRewriter;
    private final Map<String, MechanismRealmConfiguration> mechanismRealms;
    private final List<SecurityFactory<Credential>> serverCredentialFactories;
    public static final MechanismConfiguration EMPTY = new MechanismConfiguration(NameRewriter.IDENTITY_REWRITER, NameRewriter.IDENTITY_REWRITER, NameRewriter.IDENTITY_REWRITER, Collections.emptyList(), Collections.emptyList());

    MechanismConfiguration(NameRewriter preRealmRewriter, NameRewriter postRealmRewriter, NameRewriter finalRewriter, Collection<MechanismRealmConfiguration> mechanismRealms, List<SecurityFactory<Credential>> serverCredentialFactories) {
        Assert.checkNotNullParam((String)"preRealmRewriter", (Object)preRealmRewriter);
        Assert.checkNotNullParam((String)"postRealmRewriter", (Object)postRealmRewriter);
        Assert.checkNotNullParam((String)"finalRewriter", (Object)finalRewriter);
        Assert.checkNotNullParam((String)"mechanismRealms", mechanismRealms);
        Assert.checkNotNullParam((String)"serverCredentials", serverCredentialFactories);
        this.preRealmRewriter = preRealmRewriter;
        this.postRealmRewriter = postRealmRewriter;
        this.finalRewriter = finalRewriter;
        Iterator<MechanismRealmConfiguration> iterator = mechanismRealms.iterator();
        if (!iterator.hasNext()) {
            this.mechanismRealms = Collections.emptyMap();
        } else {
            MechanismRealmConfiguration item = iterator.next();
            if (!iterator.hasNext()) {
                this.mechanismRealms = Collections.singletonMap(item.getRealmName(), item);
            } else {
                LinkedHashMap<String, MechanismRealmConfiguration> map = new LinkedHashMap<String, MechanismRealmConfiguration>(mechanismRealms.size());
                map.put(item.getRealmName(), item);
                do {
                    item = iterator.next();
                    map.put(item.getRealmName(), item);
                } while (iterator.hasNext());
                this.mechanismRealms = Collections.unmodifiableMap(map);
            }
        }
        this.serverCredentialFactories = serverCredentialFactories;
    }

    public NameRewriter getPreRealmRewriter() {
        return this.preRealmRewriter;
    }

    public NameRewriter getPostRealmRewriter() {
        return this.postRealmRewriter;
    }

    public NameRewriter getFinalRewriter() {
        return this.finalRewriter;
    }

    public Collection<String> getMechanismRealmNames() {
        return this.mechanismRealms.keySet();
    }

    public List<SecurityFactory<Credential>> getServerCredentialFactories() {
        return this.serverCredentialFactories;
    }

    public MechanismRealmConfiguration getMechanismRealmConfiguration(String realmName) {
        return this.mechanismRealms.get(realmName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final MechanismRealmConfiguration[] NO_REALM_CONFIGS = new MechanismRealmConfiguration[0];
        private static final SecurityFactory<Credential>[] NO_CREDENTIALS = new SecurityFactory[0];
        private NameRewriter preRealmRewriter = NameRewriter.IDENTITY_REWRITER;
        private NameRewriter postRealmRewriter = NameRewriter.IDENTITY_REWRITER;
        private NameRewriter finalRewriter = NameRewriter.IDENTITY_REWRITER;
        private List<MechanismRealmConfiguration> mechanismRealms;
        private List<SecurityFactory<Credential>> serverCredentials;

        Builder() {
        }

        public Builder setPreRealmRewriter(NameRewriter preRealmRewriter) {
            Assert.checkNotNullParam((String)"preRealmRewriter", (Object)preRealmRewriter);
            this.preRealmRewriter = preRealmRewriter;
            return this;
        }

        public Builder setPostRealmRewriter(NameRewriter postRealmRewriter) {
            Assert.checkNotNullParam((String)"postRealmRewriter", (Object)postRealmRewriter);
            this.postRealmRewriter = postRealmRewriter;
            return this;
        }

        public Builder setFinalRewriter(NameRewriter finalRewriter) {
            Assert.checkNotNullParam((String)"finalRewriter", (Object)finalRewriter);
            this.finalRewriter = finalRewriter;
            return this;
        }

        public Builder addMechanismRealm(MechanismRealmConfiguration configuration) {
            Assert.checkNotNullParam((String)"configuration", (Object)configuration);
            List<MechanismRealmConfiguration> mechanismRealms = this.mechanismRealms;
            if (mechanismRealms == null) {
                mechanismRealms = this.mechanismRealms = new ArrayList<MechanismRealmConfiguration>(1);
            }
            mechanismRealms.add(configuration);
            return this;
        }

        public Builder addServerCredential(Credential credential) {
            Assert.checkNotNullParam((String)"credential", (Object)credential);
            List<SecurityFactory<Credential>> serverCredentials = this.serverCredentials;
            if (serverCredentials == null) {
                serverCredentials = this.serverCredentials = new ArrayList<SecurityFactory<Credential>>(1);
            }
            serverCredentials.add(new FixedSecurityFactory<Credential>(credential));
            return this;
        }

        public Builder addServerCredential(SecurityFactory<Credential> credentialFactory) {
            Assert.checkNotNullParam((String)"credential", credentialFactory);
            List<SecurityFactory<Credential>> serverCredentials = this.serverCredentials;
            if (serverCredentials == null) {
                serverCredentials = this.serverCredentials = new ArrayList<SecurityFactory<Credential>>(1);
            }
            serverCredentials.add(credentialFactory);
            return this;
        }

        public MechanismConfiguration build() {
            List<MechanismRealmConfiguration> mechanismRealms = this.mechanismRealms;
            mechanismRealms = mechanismRealms == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(mechanismRealms.toArray(NO_REALM_CONFIGS)));
            List<SecurityFactory<Credential>> serverCredentials = this.serverCredentials;
            serverCredentials = serverCredentials == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(serverCredentials.toArray(NO_CREDENTIALS)));
            return new MechanismConfiguration(this.preRealmRewriter, this.postRealmRewriter, this.finalRewriter, mechanismRealms, serverCredentials);
        }
    }
}

