/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.callback;

import java.io.Serializable;
import java.security.Principal;
import org.wildfly.security.auth.callback.ExtendedCallback;
import org.wildfly.security.credential.Credential;

public final class VerifyPeerTrustedCallback
implements ExtendedCallback,
Serializable {
    private static final long serialVersionUID = -2830410786419507677L;
    private final Principal principal;
    private final Credential credential;
    private boolean verified = false;

    public VerifyPeerTrustedCallback(Principal principal, Credential credential) {
        this.principal = principal;
        this.credential = credential;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public <C extends Credential> C getCredential(Class<C> credentialClass) {
        Credential credential = this.credential;
        return (C)(credentialClass.isInstance(credential) ? (Credential)credentialClass.cast(credential) : null);
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public boolean isVerified() {
        return this.verified;
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean needsInformation() {
        return true;
    }
}

