/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import org.wildfly.security.password.impl.AbstractPasswordImpl;
import org.wildfly.security.password.interfaces.OneTimePassword;
import org.wildfly.security.password.spec.OneTimePasswordSpec;

class OneTimePasswordImpl
extends AbstractPasswordImpl
implements OneTimePassword {
    private static final long serialVersionUID = 5524179164918986449L;
    private final String algorithm;
    private final byte[] hash;
    private final byte[] seed;
    private final int sequenceNumber;

    OneTimePasswordImpl(String algorithm, byte[] hash, byte[] seed, int sequenceNumber) {
        this.algorithm = algorithm;
        this.hash = hash;
        this.seed = seed;
        this.sequenceNumber = sequenceNumber;
    }

    OneTimePasswordImpl(OneTimePassword password) {
        this(password.getAlgorithm(), (byte[])password.getHash().clone(), (byte[])password.getSeed().clone(), password.getSequenceNumber());
    }

    OneTimePasswordImpl(String algorithm, OneTimePasswordSpec spec) {
        this(algorithm, (byte[])spec.getHash().clone(), (byte[])spec.getSeed().clone(), spec.getSequenceNumber());
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] getHash() {
        return (byte[])this.hash.clone();
    }

    @Override
    public byte[] getSeed() {
        return (byte[])this.seed.clone();
    }

    @Override
    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    <S extends KeySpec> S getKeySpec(Class<S> keySpecType) throws InvalidKeySpecException {
        if (keySpecType.isAssignableFrom(OneTimePasswordSpec.class)) {
            return (S)((KeySpec)keySpecType.cast(new OneTimePasswordSpec((byte[])this.hash.clone(), (byte[])this.seed.clone(), this.sequenceNumber)));
        }
        throw new InvalidKeySpecException();
    }

    @Override
    boolean verify(char[] guess) throws InvalidKeyException {
        throw new InvalidKeyException();
    }

    @Override
    <T extends KeySpec> boolean convertibleTo(Class<T> keySpecType) {
        return keySpecType.isAssignableFrom(OneTimePasswordSpec.class);
    }

    private void readObject(ObjectInputStream ignored) throws NotSerializableException {
        throw new NotSerializableException();
    }

    Object writeReplace() {
        return OneTimePassword.createRaw(this.algorithm, this.hash, this.seed, this.sequenceNumber);
    }

    @Override
    public OneTimePasswordImpl clone() {
        return this;
    }
}

