/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.util.Set;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

class FilterSaslMechanismAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final boolean allow;
    private final Set<String> names;

    FilterSaslMechanismAuthenticationConfiguration(AuthenticationConfiguration parent, boolean allow, Set<String> names) {
        super(parent, true);
        this.allow = allow;
        this.names = names;
    }

    @Override
    boolean filterOneSaslMechanism(String mechanismName) {
        return this.names.contains(mechanismName) ? this.allow : super.filterOneSaslMechanism(mechanismName);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new FilterSaslMechanismAuthenticationConfiguration(newParent, this.allow, this.names);
    }

    @Override
    StringBuilder asString(StringBuilder sb) {
        this.parentAsString(sb);
        sb.append("FilterSaslMechanism allow=").append(this.allow).append(",name=[ ");
        if (this.names != null) {
            this.names.forEach(s -> sb.append((String)s).append(' '));
        }
        sb.append("],");
        return sb;
    }
}

