/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Map;

public abstract class AbstractSaslFactory {
    static final String[] EMPTY = new String[0];
    private final String[] names;

    protected AbstractSaslFactory(String name) {
        this.names = new String[]{name};
    }

    public String[] getMechanismNames(Map<String, ?> props) {
        if (this.matches(props)) {
            return this.names;
        }
        return EMPTY;
    }

    protected boolean matches(Map<String, ?> props) {
        return !(!this.getPropertyValue("wildfly.sasl.mechanism-query-all", props, false) && (this.getPropertyValue("javax.security.sasl.policy.noplaintext", props, false) && this.isPlainText() || this.getPropertyValue("javax.security.sasl.policy.noanonymous", props, false) && this.isAnonymous() || this.getPropertyValue("javax.security.sasl.policy.forward", props, false) && !this.isForwardSecrecy() || this.getPropertyValue("javax.security.sasl.policy.noactive", props, false) && this.isActiveSusceptible() || this.getPropertyValue("javax.security.sasl.policy.nodictionary", props, false) && this.isDictionarySusceptible() || this.getPropertyValue("javax.security.sasl.policy.credentials", props, false) && !this.isPassCredentials()));
    }

    protected boolean isPassCredentials() {
        return false;
    }

    protected boolean isDictionarySusceptible() {
        return true;
    }

    protected boolean isActiveSusceptible() {
        return true;
    }

    protected boolean isForwardSecrecy() {
        return false;
    }

    protected boolean isPlainText() {
        return true;
    }

    protected boolean isAnonymous() {
        return true;
    }

    protected boolean getPropertyValue(String property, Map<String, ?> props, boolean defaultValue) {
        return props == null || !props.containsKey(property) ? defaultValue : Boolean.parseBoolean(props.get(property).toString());
    }

    protected boolean isIncluded(String ... names) {
        String ourName = this.names[0];
        for (String name : names) {
            if (!name.equals(ourName)) continue;
            return true;
        }
        return false;
    }
}

