/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.io.IOException;
import java.security.Principal;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.naming.InvalidNameException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.Rdn;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.IdentitySharedExclusiveLock;
import org.wildfly.security.auth.realm.ldap.AttributeMapping;
import org.wildfly.security.auth.realm.ldap.CredentialLoader;
import org.wildfly.security.auth.realm.ldap.CredentialPersister;
import org.wildfly.security.auth.realm.ldap.DelegatingLdapContext;
import org.wildfly.security.auth.realm.ldap.EvidenceVerifier;
import org.wildfly.security.auth.realm.ldap.IdentityCredentialLoader;
import org.wildfly.security.auth.realm.ldap.IdentityCredentialPersister;
import org.wildfly.security.auth.realm.ldap.IdentityEvidenceVerifier;
import org.wildfly.security.auth.server.CloseableIterator;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.AlgorithmEvidence;
import org.wildfly.security.evidence.Evidence;

class LdapSecurityRealm
implements ModifiableSecurityRealm {
    private final Supplier<Provider[]> providers;
    private final ExceptionSupplier<DirContext, NamingException> dirContextSupplier;
    private final NameRewriter nameRewriter;
    private final IdentityMapping identityMapping;
    private final int pageSize;
    private final List<CredentialLoader> credentialLoaders;
    private final List<CredentialPersister> credentialPersisters;
    private final List<EvidenceVerifier> evidenceVerifiers;
    private final ConcurrentHashMap<String, IdentitySharedExclusiveLock> realmIdentityLocks = new ConcurrentHashMap();

    LdapSecurityRealm(Supplier<Provider[]> providers, ExceptionSupplier<DirContext, NamingException> dirContextSupplier, NameRewriter nameRewriter, IdentityMapping identityMapping, List<CredentialLoader> credentialLoaders, List<CredentialPersister> credentialPersisters, List<EvidenceVerifier> evidenceVerifiers, int pageSize) {
        this.providers = providers;
        this.dirContextSupplier = dirContextSupplier;
        this.nameRewriter = nameRewriter;
        this.identityMapping = identityMapping;
        this.pageSize = pageSize;
        this.credentialLoaders = credentialLoaders;
        this.credentialPersisters = credentialPersisters;
        this.evidenceVerifiers = evidenceVerifiers;
    }

    @Override
    public RealmIdentity getRealmIdentity(Principal principal) {
        return this.getRealmIdentity(principal, false);
    }

    @Override
    public ModifiableRealmIdentity getRealmIdentityForUpdate(Principal principal) {
        return this.getRealmIdentity(principal, true);
    }

    private ModifiableRealmIdentity getRealmIdentity(Principal principal, boolean exclusive) {
        if (!(principal instanceof NamePrincipal)) {
            return ModifiableRealmIdentity.NON_EXISTENT;
        }
        String name = this.nameRewriter.rewriteName(principal.getName());
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        IdentitySharedExclusiveLock realmIdentityLock = this.getRealmIdentityLockForName(name);
        IdentitySharedExclusiveLock.IdentityLock lock = exclusive ? realmIdentityLock.lockExclusive() : realmIdentityLock.lockShared();
        return new LdapRealmIdentity(name, lock);
    }

    private DirContext obtainContext() throws RealmUnavailableException {
        try {
            return (DirContext)this.dirContextSupplier.get();
        }
        catch (NamingException e) {
            throw ElytronMessages.log.ldapRealmFailedToObtainContext(e);
        }
    }

    private void closeContext(DirContext dirContext) {
        try {
            dirContext.close();
        }
        catch (NamingException e) {
            ElytronMessages.log.debug("LdapSecurityRealm failed to close DirContext", e);
        }
    }

    @Override
    public CloseableIterator<ModifiableRealmIdentity> getRealmIdentityIterator() throws RealmUnavailableException {
        Stream<SearchResult> resultStream;
        DirContext dirContext;
        if (this.identityMapping.iteratorFilter == null) {
            throw ElytronMessages.log.ldapRealmNotConfiguredToSupportIteratingOverIdentities();
        }
        LdapSearch ldapSearch = new LdapSearch(this.identityMapping.searchDn, this.identityMapping.searchRecursive, this.pageSize, this.identityMapping.iteratorFilter, new String[0]);
        ldapSearch.setReturningAttributes(this.identityMapping.rdnIdentifier);
        try {
            dirContext = (DirContext)this.dirContextSupplier.get();
            resultStream = ldapSearch.search(dirContext);
        }
        catch (NamingException e) {
            throw ElytronMessages.log.ldapRealmIdentitySearchFailed(e);
        }
        final Iterator iterator = resultStream.iterator();
        return new CloseableIterator<ModifiableRealmIdentity>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public ModifiableRealmIdentity next() {
                SearchResult entry = (SearchResult)iterator.next();
                try {
                    String name = (String)entry.getAttributes().get(LdapSecurityRealm.this.identityMapping.rdnIdentifier).get();
                    return LdapSecurityRealm.this.getRealmIdentityForUpdate(new NamePrincipal(name));
                }
                catch (NamingException e) {
                    throw ElytronMessages.log.ldapRealmIdentitySearchFailed(e);
                }
            }

            @Override
            public void close() throws IOException {
                resultStream.close();
                LdapSecurityRealm.this.closeContext(dirContext);
            }
        };
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        SupportLevel response = SupportLevel.UNSUPPORTED;
        for (CredentialLoader loader : this.credentialLoaders) {
            SupportLevel support = loader.getCredentialAcquireSupport(credentialType, algorithmName);
            if (support.isDefinitelySupported()) {
                return support;
            }
            if (response.compareTo(support) >= 0) continue;
            response = support;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"evidenceType", evidenceType);
        SupportLevel response = SupportLevel.UNSUPPORTED;
        DirContext dirContext = this.obtainContext();
        try {
            for (EvidenceVerifier verifier : this.evidenceVerifiers) {
                SupportLevel support = verifier.getEvidenceVerifySupport(dirContext, evidenceType, algorithmName);
                if (support.isDefinitelySupported()) {
                    SupportLevel supportLevel = support;
                    return supportLevel;
                }
                if (response.compareTo(support) >= 0) continue;
                response = support;
            }
        }
        finally {
            this.closeContext(dirContext);
        }
        return response;
    }

    private IdentitySharedExclusiveLock getRealmIdentityLockForName(String name) {
        IdentitySharedExclusiveLock newRealmIdentityLock;
        IdentitySharedExclusiveLock realmIdentityLock = this.realmIdentityLocks.get(name);
        if (realmIdentityLock == null && (realmIdentityLock = this.realmIdentityLocks.putIfAbsent(name, newRealmIdentityLock = new IdentitySharedExclusiveLock())) == null) {
            realmIdentityLock = newRealmIdentityLock;
        }
        return realmIdentityLock;
    }

    static class IdentityMapping {
        private final String searchDn;
        private final boolean searchRecursive;
        public final int searchTimeLimit;
        private final String rdnIdentifier;
        private final List<AttributeMapping> attributes;
        private final LdapName newIdentityParent;
        private final javax.naming.directory.Attributes newIdentityAttributes;
        private final String filterName;
        private final String iteratorFilter;

        public IdentityMapping(String searchDn, boolean searchRecursive, int searchTimeLimit, String rdnIdentifier, List<AttributeMapping> attributes, LdapName newIdentityParent, javax.naming.directory.Attributes newIdentityAttributes, String filterName, String iteratorFilter) {
            Assert.checkNotNullParam((String)"rdnIdentifier", (Object)rdnIdentifier);
            this.searchDn = searchDn;
            this.searchRecursive = searchRecursive;
            this.searchTimeLimit = searchTimeLimit;
            this.rdnIdentifier = rdnIdentifier;
            this.attributes = attributes;
            this.newIdentityParent = newIdentityParent;
            this.newIdentityAttributes = newIdentityAttributes;
            this.filterName = filterName;
            this.iteratorFilter = iteratorFilter;
        }
    }

    private class LdapSearch {
        private final String searchDn;
        private final int searchScope;
        private final int pageSize;
        private final String filter;
        private final String[] filterArgs;
        private String[] returningAttributes;
        private DirContext context;
        private NamingEnumeration<SearchResult> result;
        private byte[] cookie = null;

        public LdapSearch(String searchDn, boolean searchRecursive, int pageSize, String filter, String ... filterArgs) {
            this(searchDn, searchRecursive ? 2 : 1, pageSize, filter, filterArgs);
        }

        public LdapSearch(String searchDn, int searchScope, int pageSize, String filter, String ... filterArgs) {
            this.searchDn = searchDn;
            this.searchScope = searchScope;
            this.pageSize = pageSize;
            this.filter = filter;
            this.filterArgs = filterArgs;
        }

        public Stream<SearchResult> search(DirContext ctx) throws RealmUnavailableException {
            ElytronMessages.log.debugf("Executing search [%s] in context [%s] with arguments [%s]. Returning attributes are [%s]", new Object[]{this.filter, this.searchDn, this.filterArgs, this.returningAttributes});
            this.context = ctx;
            try {
                this.result = this.searchWithPagination();
                return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<SearchResult>(Long.MAX_VALUE, 256){

                    @Override
                    public boolean tryAdvance(Consumer<? super SearchResult> action) {
                        try {
                            while (true) {
                                try {
                                    if (!LdapSearch.this.result.hasMore()) {
                                        if (LdapSearch.this.pageSize == 0 || !(LdapSearch.this.context instanceof LdapContext)) {
                                            ElytronMessages.log.trace("Identity iterating - pagination not supported - end of list");
                                            return false;
                                        }
                                        Control[] controls = ((LdapContext)LdapSearch.this.context).getResponseControls();
                                        if (controls != null) {
                                            for (Control control : controls) {
                                                if (!(control instanceof PagedResultsResponseControl)) continue;
                                                LdapSearch.access$2002(LdapSearch.this, ((PagedResultsResponseControl)control).getCookie());
                                                if (LdapSearch.this.cookie != null) continue;
                                                ElytronMessages.log.trace("Identity iterating - no more pages - end of list");
                                                return false;
                                            }
                                        }
                                        LdapSearch.this.result.close();
                                        LdapSearch.this.result = LdapSearch.this.searchWithPagination();
                                        if (!LdapSearch.this.result.hasMore()) {
                                            ElytronMessages.log.trace("Identity iterating - even after page loading no results - end of list");
                                            return false;
                                        }
                                    }
                                    SearchResult entry = (SearchResult)LdapSearch.this.result.next();
                                    ElytronMessages.log.debugf("Found entry [%s].", entry.getNameInNamespace());
                                    action.accept(entry);
                                    return true;
                                }
                                catch (ReferralException e) {
                                    ElytronMessages.log.debug("Next referral following in identity iterating...");
                                    LdapSearch.this.context = ((DelegatingLdapContext)LdapSearch.this.context).wrapReferralContextObtaining(e);
                                    LdapSearch.this.result = LdapSearch.this.searchWithPagination();
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException | NamingException e) {
                            try {
                                LdapSearch.this.result.close();
                            }
                            catch (NamingException ex) {
                                ElytronMessages.log.trace(ex);
                            }
                            throw ElytronMessages.log.ldapRealmErrorWhileConsumingResultsFromSearch(LdapSearch.this.searchDn, LdapSearch.this.filter, Arrays.toString(LdapSearch.this.filterArgs), e);
                        }
                    }
                }, false).onClose(() -> {
                    if (this.result != null) {
                        try {
                            this.result.close();
                        }
                        catch (NamingException e) {
                            ElytronMessages.log.trace(e);
                        }
                    }
                });
            }
            catch (NameNotFoundException e) {
                ElytronMessages.log.trace(e);
                return Stream.empty();
            }
            catch (Exception e) {
                throw ElytronMessages.log.ldapRealmIdentitySearchFailed(e);
            }
        }

        private NamingEnumeration<SearchResult> searchWithPagination() throws NamingException, IOException {
            Control[] controlsBackup = null;
            if (this.pageSize != 0 && this.context instanceof LdapContext) {
                controlsBackup = ((LdapContext)this.context).getRequestControls();
                ((LdapContext)this.context).setRequestControls(new Control[]{new PagedResultsControl(this.pageSize, this.cookie, true)});
            }
            NamingEnumeration<SearchResult> results = this.context.search(this.searchDn, this.filter, (Object[])this.filterArgs, this.createSearchControls(this.searchScope, this.returningAttributes));
            if (this.pageSize != 0 && this.context instanceof LdapContext) {
                ((LdapContext)this.context).setRequestControls(controlsBackup);
            }
            return results;
        }

        public void setReturningAttributes(String ... returningAttributes) {
            this.returningAttributes = returningAttributes;
        }

        private SearchControls createSearchControls(int searchScope, String ... returningAttributes) {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(searchScope);
            searchControls.setTimeLimit(((LdapSecurityRealm)LdapSecurityRealm.this).identityMapping.searchTimeLimit);
            searchControls.setReturningAttributes(returningAttributes);
            return searchControls;
        }

        static /* synthetic */ byte[] access$2002(LdapSearch x0, byte[] x1) {
            x0.cookie = x1;
            return x1;
        }
    }

    private class LdapRealmIdentity
    implements ModifiableRealmIdentity {
        private final String name;
        private LdapIdentity identity;
        private IdentitySharedExclusiveLock.IdentityLock lock;

        LdapRealmIdentity(String name, IdentitySharedExclusiveLock.IdentityLock lock) {
            this.name = name;
            this.lock = lock;
        }

        @Override
        public Principal getRealmIdentityPrincipal() {
            return new NamePrincipal(this.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            if (!this.exists()) {
                return SupportLevel.UNSUPPORTED;
            }
            if (LdapSecurityRealm.this.getCredentialAcquireSupport(credentialType, algorithmName) == SupportLevel.UNSUPPORTED) {
                return SupportLevel.UNSUPPORTED;
            }
            SupportLevel support = SupportLevel.UNSUPPORTED;
            DirContext dirContext = LdapSecurityRealm.this.obtainContext();
            try {
                for (CredentialLoader loader : LdapSecurityRealm.this.credentialLoaders) {
                    if (!loader.getCredentialAcquireSupport(credentialType, algorithmName).mayBeSupported()) continue;
                    IdentityCredentialLoader icl = loader.forIdentity(dirContext, this.identity.getDistinguishedName());
                    SupportLevel temp = icl.getCredentialAcquireSupport(credentialType, algorithmName, LdapSecurityRealm.this.providers);
                    if (temp != null && temp.isDefinitelySupported()) {
                        SupportLevel supportLevel = temp;
                        return supportLevel;
                    }
                    if (temp == null || support.compareTo(temp) >= 0) continue;
                    support = temp;
                }
            }
            finally {
                LdapSecurityRealm.this.closeContext(dirContext);
            }
            return support;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.getCredential(credentialType, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            if (!this.exists()) {
                return null;
            }
            if (LdapSecurityRealm.this.getCredentialAcquireSupport(credentialType, algorithmName) == SupportLevel.UNSUPPORTED) {
                return null;
            }
            DirContext dirContext = LdapSecurityRealm.this.obtainContext();
            try {
                for (CredentialLoader loader : LdapSecurityRealm.this.credentialLoaders) {
                    IdentityCredentialLoader icl;
                    C credential;
                    if (!loader.getCredentialAcquireSupport(credentialType, algorithmName).mayBeSupported() || !credentialType.isInstance(credential = (icl = loader.forIdentity(dirContext, this.identity.getDistinguishedName())).getCredential(credentialType, algorithmName, LdapSecurityRealm.this.providers))) continue;
                    Credential credential2 = (Credential)credentialType.cast(credential);
                    return (C)credential2;
                }
            }
            finally {
                LdapSecurityRealm.this.closeContext(dirContext);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCredentials(Collection<? extends Credential> credentials) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentials", credentials);
            if (!this.exists()) {
                throw ElytronMessages.log.ldapRealmIdentityNotExists(this.name);
            }
            DirContext dirContext = LdapSecurityRealm.this.obtainContext();
            try {
                String algorithmName;
                Class<?> credentialType;
                for (Credential credential : credentials) {
                    credentialType = credential.getClass();
                    algorithmName = credential instanceof AlgorithmCredential ? ((AlgorithmCredential)credential).getAlgorithm() : null;
                    boolean supported = false;
                    for (CredentialPersister persister : LdapSecurityRealm.this.credentialPersisters) {
                        IdentityCredentialPersister icp = persister.forIdentity(dirContext, this.identity.getDistinguishedName());
                        if (!icp.getCredentialPersistSupport(credentialType, algorithmName)) continue;
                        supported = true;
                    }
                    if (supported) continue;
                    throw ElytronMessages.log.ldapRealmsPersisterNotSupported();
                }
                for (CredentialPersister credentialPersister : LdapSecurityRealm.this.credentialPersisters) {
                    IdentityCredentialPersister icp = credentialPersister.forIdentity(dirContext, this.identity.getDistinguishedName());
                    icp.clearCredentials();
                }
                block6: for (Credential credential : credentials) {
                    credentialType = credential.getClass();
                    algorithmName = credential instanceof AlgorithmCredential ? ((AlgorithmCredential)credential).getAlgorithm() : null;
                    for (CredentialPersister persister : LdapSecurityRealm.this.credentialPersisters) {
                        IdentityCredentialPersister icp = persister.forIdentity(dirContext, this.identity.getDistinguishedName());
                        if (!icp.getCredentialPersistSupport(credentialType, algorithmName)) continue;
                        icp.persistCredential(credential);
                        continue block6;
                    }
                }
            }
            finally {
                LdapSecurityRealm.this.closeContext(dirContext);
            }
        }

        @Override
        public void dispose() {
            IdentitySharedExclusiveLock.IdentityLock identityLock = this.lock;
            this.lock = null;
            if (identityLock != null) {
                identityLock.release();
            }
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            if (!this.exists()) {
                return AuthorizationIdentity.EMPTY;
            }
            return AuthorizationIdentity.basicIdentity(this.identity.attributes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidenceType", evidenceType);
            if (!this.exists()) {
                return SupportLevel.UNSUPPORTED;
            }
            SupportLevel response = SupportLevel.UNSUPPORTED;
            DirContext dirContext = LdapSecurityRealm.this.obtainContext();
            try {
                for (EvidenceVerifier verifier : LdapSecurityRealm.this.evidenceVerifiers) {
                    if (!verifier.getEvidenceVerifySupport(dirContext, evidenceType, algorithmName).mayBeSupported()) continue;
                    IdentityEvidenceVerifier iev = verifier.forIdentity(dirContext, this.identity.getDistinguishedName());
                    SupportLevel support = iev.getEvidenceVerifySupport(evidenceType, algorithmName, LdapSecurityRealm.this.providers);
                    if (support != null && support.isDefinitelySupported()) {
                        SupportLevel supportLevel = support;
                        return supportLevel;
                    }
                    if (support == null || support.compareTo(response) <= 0) continue;
                    response = support;
                }
            }
            finally {
                LdapSecurityRealm.this.closeContext(dirContext);
            }
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            String algorithmName;
            Assert.checkNotNullParam((String)"evidence", (Object)evidence);
            if (!this.exists()) {
                return false;
            }
            Class<?> evidenceType = evidence.getClass();
            String string = algorithmName = evidence instanceof AlgorithmEvidence ? ((AlgorithmEvidence)evidence).getAlgorithm() : null;
            if (LdapSecurityRealm.this.getEvidenceVerifySupport(evidenceType, algorithmName) == SupportLevel.UNSUPPORTED) {
                return false;
            }
            DirContext dirContext = LdapSecurityRealm.this.obtainContext();
            try {
                for (EvidenceVerifier verifier : LdapSecurityRealm.this.evidenceVerifiers) {
                    IdentityEvidenceVerifier iev;
                    if (!verifier.getEvidenceVerifySupport(dirContext, evidenceType, algorithmName).mayBeSupported() || !(iev = verifier.forIdentity(dirContext, this.identity.getDistinguishedName())).verifyEvidence(evidence, LdapSecurityRealm.this.providers)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                LdapSecurityRealm.this.closeContext(dirContext);
            }
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            boolean exists;
            if (this.identity == null) {
                this.identity = this.getIdentity();
            }
            boolean bl = exists = this.identity != null;
            if (!exists) {
                ElytronMessages.log.debugf("Principal [%s] does not exists.", this.name);
            }
            return exists;
        }

        private LdapSearch searchIdentityByDn() {
            if (!this.name.regionMatches(true, 0, LdapSecurityRealm.this.identityMapping.rdnIdentifier, 0, LdapSecurityRealm.this.identityMapping.rdnIdentifier.length())) {
                return null;
            }
            try {
                LdapName ldapName = new LdapName(this.name);
                int rdnPosition = ldapName.size() - 1;
                Rdn rdnIdentifier = ldapName.getRdn(rdnPosition);
                if (!rdnIdentifier.getType().equalsIgnoreCase(LdapSecurityRealm.this.identityMapping.rdnIdentifier)) {
                    ElytronMessages.log.tracef("Getting identity [%s] by DN skipped - RDN does not match [%s]", this.name, LdapSecurityRealm.this.identityMapping.rdnIdentifier);
                    return null;
                }
                if (LdapSecurityRealm.this.identityMapping.searchDn != null && !ldapName.startsWith(new LdapName(LdapSecurityRealm.this.identityMapping.searchDn).getRdns())) {
                    ElytronMessages.log.tracef("Getting identity [%s] by DN skipped - DN not in search-dn [%s]", this.name, LdapSecurityRealm.this.identityMapping.searchDn);
                    return null;
                }
                return new LdapSearch(ldapName.toString(), 0, 0, LdapSecurityRealm.this.identityMapping.filterName, rdnIdentifier.getValue().toString());
            }
            catch (InvalidNameException e) {
                ElytronMessages.log.tracef(e, "Getting identity [%s] by DN failed - will continue by name", this.name);
                return null;
            }
        }

        /*
         * Loose catch block
         */
        private LdapIdentity getIdentity() throws RealmUnavailableException {
            DirContext context;
            ElytronMessages.log.debugf("Trying to create identity for principal [%s].", this.name);
            try {
                context = (DirContext)LdapSecurityRealm.this.dirContextSupplier.get();
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmFailedObtainIdentityFromServer(this.name, e);
            }
            try {
                LdapSearch ldapSearch = this.searchIdentityByDn();
                if (ldapSearch == null) {
                    ldapSearch = new LdapSearch(LdapSecurityRealm.this.identityMapping.searchDn, LdapSecurityRealm.this.identityMapping.searchRecursive, 0, LdapSecurityRealm.this.identityMapping.filterName, this.name);
                }
                ldapSearch.setReturningAttributes((String[])LdapSecurityRealm.this.identityMapping.attributes.stream().filter(mapping -> !mapping.isFiltered()).map(AttributeMapping::getLdapName).toArray(String[]::new));
                try (Stream<LdapIdentity> identityStream = ldapSearch.search(context).map(result -> {
                    MapAttributes identityAttributes = new MapAttributes();
                    identityAttributes.addAll(this.extractSingleAttributes((SearchResult)result));
                    identityAttributes.addAll(this.extractFilteredAttributes((SearchResult)result, context));
                    return new LdapIdentity(result.getNameInNamespace(), identityAttributes.asReadOnly());
                });){
                    Optional<LdapIdentity> optional = identityStream.findFirst();
                    if (optional.isPresent()) {
                        LdapIdentity identity = optional.get();
                        if (ElytronMessages.log.isDebugEnabled()) {
                            ElytronMessages.log.debugf("Successfully created identity for principal [%s].", this.name);
                            if (identity.attributes.isEmpty()) {
                                ElytronMessages.log.debugf("Identity [%s] does not have any attributes.", this.name);
                            } else {
                                ElytronMessages.log.debugf("Identity [%s] attributes are:", this.name);
                                identity.attributes.keySet().forEach(key -> {
                                    Attributes.Entry values = identity.attributes.get((String)key);
                                    values.forEach(value -> ElytronMessages.log.debugf("    Attribute [%s] value [%s].", key, value));
                                });
                            }
                        }
                        LdapIdentity ldapIdentity = identity;
                        return ldapIdentity;
                    }
                    LdapIdentity ldapIdentity = null;
                    return ldapIdentity;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                LdapSecurityRealm.this.closeContext(context);
            }
        }

        private String valueFromDn(AttributeMapping mapping, String dn) {
            String valueRdn = mapping.getRdn();
            try {
                for (Rdn rdn : new LdapName(dn).getRdns()) {
                    if (!rdn.getType().equalsIgnoreCase(valueRdn)) continue;
                    return rdn.getValue().toString();
                }
            }
            catch (Exception cause) {
                throw ElytronMessages.log.ldapRealmInvalidRdnForAttribute(mapping.getName(), dn, valueRdn, cause);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void valuesFromAttribute(SearchResult entry, AttributeMapping mapping, Collection<String> identityAttributeValues) throws NamingException {
            if (mapping.getLdapName() == null) {
                String value = entry.getNameInNamespace();
                if (mapping.getRdn() != null) {
                    value = this.valueFromDn(mapping, value);
                }
                identityAttributeValues.add(value);
            } else {
                javax.naming.directory.Attributes entryAttributes = entry.getAttributes();
                Attribute ldapAttribute = entryAttributes.get(mapping.getLdapName());
                if (ldapAttribute == null) {
                    return;
                }
                NamingEnumeration<?> attributesEnum = null;
                try {
                    attributesEnum = ldapAttribute.getAll();
                    Stream<String> values = Collections.list(attributesEnum).stream().map(Object::toString);
                    if (mapping.getRdn() != null) {
                        values = values.map(val -> this.valueFromDn(mapping, (String)val)).filter(val -> val != null);
                    }
                    values.forEach(identityAttributeValues::add);
                }
                finally {
                    if (attributesEnum != null) {
                        try {
                            attributesEnum.close();
                        }
                        catch (NamingException namingException) {}
                    }
                }
            }
        }

        private Map<String, Collection<String>> extractFilteredAttributes(SearchResult identityEntry, DirContext context) {
            return this.extractAttributes(AttributeMapping::isFiltered, mapping -> {
                ArrayList<String> identityAttributeValues = new ArrayList<String>();
                this.extractFilteredAttributesRecursion(identityEntry, (AttributeMapping)mapping, context, 0, (Collection<String>)identityAttributeValues);
                return identityAttributeValues;
            });
        }

        private void extractFilteredAttributesRecursion(SearchResult referencedEntry, AttributeMapping mapping, DirContext context, int depth, Collection<String> identityAttributeValues) {
            String referencedDn = referencedEntry.getNameInNamespace();
            String searchDn = mapping.getSearchDn() != null ? mapping.getSearchDn() : LdapSecurityRealm.this.identityMapping.searchDn;
            LdapSearch search = new LdapSearch(searchDn, mapping.getRecursiveSearch(), 0, mapping.getFilter(), referencedDn);
            search.setReturningAttributes(mapping.getLdapName());
            try (Stream<SearchResult> entries = search.search(context);){
                entries.forEach(entry -> {
                    try {
                        this.valuesFromAttribute((SearchResult)entry, mapping, identityAttributeValues);
                    }
                    catch (Exception cause) {
                        throw ElytronMessages.log.ldapRealmFailedObtainAttributes(referencedDn, cause);
                    }
                    if (mapping.getRecursiveDepth() > depth) {
                        this.extractFilteredAttributesRecursion((SearchResult)entry, mapping, context, depth + 1, identityAttributeValues);
                    }
                });
            }
            catch (Exception cause) {
                throw ElytronMessages.log.ldapRealmFailedObtainAttributes(referencedDn, cause);
            }
        }

        private Map<String, Collection<String>> extractSingleAttributes(SearchResult identityEntry) {
            String principalDn = identityEntry.getNameInNamespace();
            return this.extractAttributes(mapping -> !mapping.isFiltered(), mapping -> {
                ArrayList<String> identityAttributeValues = new ArrayList<String>();
                try {
                    this.valuesFromAttribute(identityEntry, (AttributeMapping)mapping, (Collection<String>)identityAttributeValues);
                }
                catch (Exception cause) {
                    throw ElytronMessages.log.ldapRealmFailedObtainAttributes(principalDn, cause);
                }
                return identityAttributeValues;
            });
        }

        private Map<String, Collection<String>> extractAttributes(Predicate<AttributeMapping> filter, Function<AttributeMapping, Collection<String>> valueFunction) {
            return LdapSecurityRealm.this.identityMapping.attributes.stream().filter(filter).collect(Collectors.toMap(AttributeMapping::getName, valueFunction, (m1, m2) -> {
                ArrayList merged = new ArrayList(m1);
                merged.addAll(m2);
                return merged;
            }));
        }

        @Override
        public void delete() throws RealmUnavailableException {
            DirContext context;
            if (this.identity == null) {
                this.identity = this.getIdentity();
            }
            if (this.identity == null) {
                throw ElytronMessages.log.noSuchIdentity();
            }
            try {
                context = (DirContext)LdapSecurityRealm.this.dirContextSupplier.get();
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmFailedDeleteIdentityFromServer(e);
            }
            try {
                ElytronMessages.log.debugf("Removing identity [%s] with DN [%s] from LDAP", this.name, this.identity.getDistinguishedName());
                context.destroySubcontext(new LdapName(this.identity.getDistinguishedName()));
                this.identity = null;
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmFailedDeleteIdentityFromServer(e);
            }
            finally {
                LdapSecurityRealm.this.closeContext(context);
            }
        }

        @Override
        public void create() throws RealmUnavailableException {
            if (LdapSecurityRealm.this.identityMapping.newIdentityParent == null || LdapSecurityRealm.this.identityMapping.newIdentityAttributes == null) {
                throw ElytronMessages.log.ldapRealmNotConfiguredToSupportCreatingIdentities();
            }
            DirContext context = null;
            try {
                context = (DirContext)LdapSecurityRealm.this.dirContextSupplier.get();
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmFailedCreateIdentityOnServer(e);
            }
            try {
                LdapName distinguishName = (LdapName)LdapSecurityRealm.this.identityMapping.newIdentityParent.clone();
                distinguishName.add(new Rdn(LdapSecurityRealm.this.identityMapping.rdnIdentifier, this.name));
                ElytronMessages.log.debugf("Creating identity [%s] with DN [%s] in LDAP", this.name, distinguishName.toString());
                context.createSubcontext(distinguishName, LdapSecurityRealm.this.identityMapping.newIdentityAttributes);
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmFailedCreateIdentityOnServer(e);
            }
            finally {
                LdapSecurityRealm.this.closeContext(context);
            }
        }

        @Override
        public void setAttributes(Attributes attributes) throws RealmUnavailableException {
            ElytronMessages.log.debugf("Trying to set attributes for principal [%s].", this.name);
            if (this.identity == null) {
                this.identity = this.getIdentity();
            }
            if (this.identity == null) {
                throw ElytronMessages.log.noSuchIdentity();
            }
            DirContext context = null;
            try {
                context = (DirContext)LdapSecurityRealm.this.dirContextSupplier.get();
            }
            catch (Exception e) {
                throw ElytronMessages.log.ldapRealmAttributesSettingFailed(this.name, e);
            }
            try {
                LinkedList<ModificationItem> modItems = new LinkedList<ModificationItem>();
                LdapName identityLdapName = new LdapName(this.identity.getDistinguishedName());
                String renameTo = null;
                for (AttributeMapping mapping : LdapSecurityRealm.this.identityMapping.attributes) {
                    BasicAttribute attribute;
                    if (mapping.getFilter() != null || mapping.getRdn() != null) {
                        if (attributes.size(mapping.getName()) == 0) continue;
                        ElytronMessages.log.ldapRealmDoesNotSupportSettingFilteredAttribute(mapping.getName(), this.name);
                        continue;
                    }
                    if (LdapSecurityRealm.this.identityMapping.rdnIdentifier.equalsIgnoreCase(mapping.getLdapName())) {
                        if (attributes.size(mapping.getName()) == 1) {
                            renameTo = attributes.get(mapping.getName(), 0);
                            continue;
                        }
                        throw ElytronMessages.log.ldapRealmRequiresExactlyOneRdnAttribute(mapping.getName(), this.name);
                    }
                    if (attributes.size(mapping.getName()) == 0) {
                        attribute = new BasicAttribute(mapping.getLdapName());
                        modItems.add(new ModificationItem(3, attribute));
                        continue;
                    }
                    attribute = new BasicAttribute(mapping.getLdapName());
                    attributes.get(mapping.getName()).forEach(entryItem -> attribute.add(entryItem));
                    modItems.add(new ModificationItem(2, attribute));
                }
                for (Attributes.Entry entry : attributes.entries()) {
                    if (LdapSecurityRealm.this.identityMapping.attributes.stream().filter(mp -> mp.getName().equals(entry.getKey())).count() != 0L) continue;
                    throw ElytronMessages.log.ldapRealmCannotSetAttributeWithoutMapping(entry.getKey(), this.name);
                }
                ModificationItem[] modItemsArray = modItems.toArray(new ModificationItem[modItems.size()]);
                context.modifyAttributes(identityLdapName, modItemsArray);
                if (renameTo != null && !renameTo.equals((String)identityLdapName.getRdn(identityLdapName.size() - 1).getValue())) {
                    LdapName newLdapName = new LdapName(identityLdapName.getRdns().subList(0, identityLdapName.size() - 1));
                    newLdapName.add(new Rdn(LdapSecurityRealm.this.identityMapping.rdnIdentifier, renameTo));
                    context.rename(identityLdapName, newLdapName);
                }
            }
            catch (Exception e) {
                throw ElytronMessages.log.ldapRealmAttributesSettingFailed(this.name, e);
            }
            finally {
                LdapSecurityRealm.this.closeContext(context);
            }
        }

        @Override
        public Attributes getAttributes() throws RealmUnavailableException {
            if (this.identity == null) {
                this.identity = this.getIdentity();
            }
            if (this.identity == null) {
                throw ElytronMessages.log.noSuchIdentity();
            }
            return this.identity.getAttributes().asReadOnly();
        }

        private class LdapIdentity {
            private final String distinguishedName;
            private final Attributes attributes;

            LdapIdentity(String distinguishedName, Attributes attributes) {
                this.distinguishedName = distinguishedName;
                this.attributes = attributes;
            }

            String getDistinguishedName() {
                return this.distinguishedName;
            }

            Attributes getAttributes() {
                return this.attributes;
            }
        }
    }
}

