/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.util.Locale;
import org.wildfly.common.Assert;

public class AttributeMapping {
    private final String ldapName;
    private final String searchDn;
    private final boolean recursiveSearch;
    private final String filter;
    private final String name;
    private final String rdn;
    private final int recursiveDepth;

    String getLdapName() {
        return this.ldapName;
    }

    String getName() {
        return this.name;
    }

    String getSearchDn() {
        return this.searchDn;
    }

    boolean getRecursiveSearch() {
        return this.recursiveSearch;
    }

    String getFilter() {
        return this.filter;
    }

    String getRdn() {
        return this.rdn;
    }

    int getRecursiveDepth() {
        return this.recursiveDepth;
    }

    boolean isFiltered() {
        return this.filter != null;
    }

    public static Builder fromAttribute(String ldapName) {
        Assert.checkNotNullParam((String)"ldapName", (Object)ldapName);
        Builder builder = new Builder();
        builder.ldapName = ldapName.toUpperCase(Locale.ROOT);
        builder.name = builder.ldapName;
        return builder;
    }

    public static Builder fromDn() {
        Builder builder = new Builder();
        builder.ldapName = null;
        builder.name = "dn";
        return builder;
    }

    public static Builder fromFilter(String filter, String ldapName) {
        Assert.checkNotNullParam((String)"filter", (Object)filter);
        Assert.checkNotNullParam((String)"ldapName", (Object)ldapName);
        Builder builder = new Builder();
        builder.filter = filter;
        builder.ldapName = ldapName.toUpperCase(Locale.ROOT);
        builder.name = builder.ldapName;
        return builder;
    }

    public static Builder fromFilterDn(String filter) {
        Assert.checkNotNullParam((String)"filter", (Object)filter);
        Builder builder = new Builder();
        builder.filter = filter;
        builder.name = "dn";
        return builder;
    }

    AttributeMapping(String searchDn, boolean recursiveSearch, String filter, String ldapName, String name, String rdn, int recursiveDepth) {
        this.searchDn = searchDn;
        this.recursiveSearch = recursiveSearch;
        this.filter = filter;
        this.ldapName = ldapName;
        this.name = name;
        this.rdn = rdn;
        this.recursiveDepth = recursiveDepth;
    }

    public static class Builder {
        private String ldapName;
        private String searchDn;
        private boolean recursiveSearch = true;
        private String filter;
        private String name;
        private String rdn;
        private int recursiveDepth;

        public Builder extractRdn(String rdn) {
            Assert.checkNotNullParam((String)"rdn", (Object)rdn);
            this.rdn = rdn;
            return this;
        }

        public Builder to(String name) {
            Assert.checkNotNullParam((String)"name", (Object)name);
            this.name = name;
            return this;
        }

        public Builder searchDn(String searchDn) {
            this.searchDn = searchDn;
            return this;
        }

        public Builder searchRecursively(boolean recursiveSearch) {
            this.recursiveSearch = recursiveSearch;
            return this;
        }

        public Builder roleRecursion(int recursiveDepth) {
            Assert.checkMinimumParameter((String)"recursiveDepth", (int)0, (int)recursiveDepth);
            Assert.checkNotNullParam((String)"filter", (Object)this.filter);
            this.recursiveDepth = recursiveDepth;
            return this;
        }

        public AttributeMapping build() {
            return new AttributeMapping(this.searchDn, this.recursiveSearch, this.filter, this.ldapName, this.name, this.rdn, this.recursiveDepth);
        }
    }
}

