/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

class SSLContextAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final SecurityFactory<SSLContext> sslContextFactory;

    SSLContextAuthenticationConfiguration(AuthenticationConfiguration parent, SSLContext sslContext) {
        this(parent, () -> sslContext);
    }

    SSLContextAuthenticationConfiguration(AuthenticationConfiguration parent, SecurityFactory<SSLContext> sslContextFactory) {
        super(parent);
        this.sslContextFactory = sslContextFactory;
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SSLContextAuthenticationConfiguration(newParent, this.sslContextFactory);
    }

    @Override
    SSLContext getSslContext() throws GeneralSecurityException {
        SSLContext context = this.sslContextFactory.create();
        return context == null ? SSLContext.getDefault() : context;
    }

    @Override
    StringBuilder asString(StringBuilder sb) {
        return this.parentAsString(sb).append("SSLContext,");
    }
}

