/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import org.wildfly.security._private.ElytronMessages;

public class ThreadLocalSSLSocketFactory
extends SocketFactory {
    private static final ThreadLocal<SocketFactory> threadLocal = new ThreadLocal();
    private SocketFactory socketFactory;

    public static SocketFactory getDefault() {
        SocketFactory socketFactory = threadLocal.get();
        if (socketFactory == null) {
            throw ElytronMessages.log.sslSocketFactoryThreadLocalNotSet();
        }
        return socketFactory;
    }

    public static void set(SocketFactory socketFactory) {
        threadLocal.set(new ThreadLocalSSLSocketFactory(socketFactory));
    }

    public static void unset() {
        threadLocal.remove();
    }

    private ThreadLocalSSLSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.socketFactory.createSocket();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.socketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.socketFactory.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.socketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.socketFactory.createSocket(address, port, localAddress, localPort);
    }
}

