/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.mechanism.oauth2;

import java.util.Map;
import java.util.NoSuchElementException;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.evidence.BearerTokenEvidence;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism.MechanismUtil;
import org.wildfly.security.mechanism.oauth2.OAuth2InitialClientMessage;
import org.wildfly.security.util.ByteIterator;

public class OAuth2Server {
    public static final String CONFIG_OPENID_CONFIGURATION_URL = "openid-configuration";
    private static final String KV_DELIMITER = "%x01";
    private final String mechanismName;
    private final CallbackHandler callbackHandler;
    private final Map<String, ?> serverConfig;

    public OAuth2Server(String mechanismName, CallbackHandler callbackHandler, Map<String, ?> serverConfig) {
        this.mechanismName = mechanismName;
        this.callbackHandler = callbackHandler;
        this.serverConfig = serverConfig;
    }

    public OAuth2InitialClientMessage parseInitialClientMessage(byte[] fromBytes) throws AuthenticationMechanismException {
        byte[] messageBytes = (byte[])fromBytes.clone();
        ByteIterator byteIterator = ByteIterator.ofBytes((byte[])fromBytes.clone());
        try {
            String auth;
            int c;
            char cbindFlag = (char)byteIterator.next();
            if (cbindFlag != 'n') {
                throw ElytronMessages.log.mechChannelBindingNotSupported(this.mechanismName);
            }
            String authorizationID = null;
            if (byteIterator.next() == 44 && (c = byteIterator.next()) == 97) {
                if (byteIterator.next() != 61) {
                    throw ElytronMessages.log.mechInvalidClientMessage(this.mechanismName);
                }
                authorizationID = byteIterator.delimitedBy(44).asUtf8String().drainToString();
                if (byteIterator.next() != 44) {
                    throw ElytronMessages.log.mechInvalidClientMessage(this.mechanismName);
                }
            }
            if ((auth = this.getValue("auth", byteIterator.asUtf8String().drainToString())) == null) {
                throw ElytronMessages.log.mechInvalidClientMessage(this.mechanismName);
            }
            return new OAuth2InitialClientMessage(authorizationID, auth, messageBytes);
        }
        catch (NoSuchElementException ignored) {
            throw ElytronMessages.log.mechInvalidMessageReceived(this.mechanismName);
        }
    }

    private String getValue(String key, String keyValuesPart) {
        for (String current : keyValuesPart.split(KV_DELIMITER)) {
            String[] keyValue = current.split("=");
            if (!keyValue[0].equals(key)) continue;
            return keyValue[1];
        }
        return null;
    }

    public byte[] evaluateInitialResponse(OAuth2InitialClientMessage initialClientMessage) throws AuthenticationMechanismException {
        if (initialClientMessage.isBearerToken()) {
            String auth = initialClientMessage.getAuth();
            String token = auth.substring(auth.indexOf(" ") + 1);
            BearerTokenEvidence evidence = new BearerTokenEvidence(token);
            EvidenceVerifyCallback evidenceVerifyCallback = new EvidenceVerifyCallback(evidence);
            try {
                MechanismUtil.handleCallbacks(this.mechanismName, this.callbackHandler, evidenceVerifyCallback);
            }
            catch (UnsupportedCallbackException e) {
                throw ElytronMessages.log.mechAuthorizationUnsupported(this.mechanismName, e);
            }
            if (evidenceVerifyCallback.isVerified()) {
                return new byte[0];
            }
            return this.createErrorMessage();
        }
        throw ElytronMessages.log.mechInvalidClientMessage(this.mechanismName);
    }

    private byte[] createErrorMessage() {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        objectBuilder.add("status", "invalid_token");
        Object asDiscoveryUrl = this.serverConfig.get(CONFIG_OPENID_CONFIGURATION_URL);
        if (asDiscoveryUrl != null) {
            objectBuilder.add(CONFIG_OPENID_CONFIGURATION_URL, asDiscoveryUrl.toString());
        }
        return ByteIterator.ofBytes(objectBuilder.build().toString().getBytes()).base64Encode().asUtf8().drain();
    }
}

