/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.key;

import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Objects;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import org.wildfly.security.key.RawKey;

class RawDHPrivateKey
extends RawKey
implements DHPrivateKey,
PrivateKey {
    private static final long serialVersionUID = -4800398215863011448L;
    private final BigInteger x;
    private final DHParameterSpec params;

    RawDHPrivateKey(DHPrivateKey original) {
        super(original);
        this.x = original.getX();
        this.params = original.getParams();
    }

    RawDHPrivateKey(Key key) {
        this((DHPrivateKey)key);
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    @Override
    public DHParameterSpec getParams() {
        return this.params;
    }

    @Override
    boolean isEqual(Key key) {
        return key instanceof DHPrivateKey && this.isEqual((DHPrivateKey)key);
    }

    boolean isEqual(DHPrivateKey key) {
        return super.isEqual(key) && Objects.equals(this.x, key.getX()) && Objects.equals(this.params, key.getParams());
    }
}

