/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.source;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;

public final class CredentialStoreCredentialSource
implements CredentialSource {
    private final CredentialStore credentialStore;
    private final String alias;

    public CredentialStoreCredentialSource(CredentialStore credentialStore, String alias) {
        Assert.checkNotNullParam((String)"credentialStore", (Object)credentialStore);
        Assert.checkNotNullParam((String)"alias", (Object)alias);
        this.credentialStore = credentialStore;
        this.alias = alias;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        try {
            return this.credentialStore.exists(this.alias, credentialType) ? SupportLevel.POSSIBLY_SUPPORTED : SupportLevel.UNSUPPORTED;
        }
        catch (CredentialStoreException e) {
            throw ElytronMessages.log.unableToReadCredential(e);
        }
        catch (UnsupportedCredentialTypeException e) {
            return SupportLevel.UNSUPPORTED;
        }
    }

    @Override
    public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        C credential;
        try {
            credential = this.credentialStore.retrieve(this.alias, credentialType);
        }
        catch (CredentialStoreException e) {
            throw ElytronMessages.log.unableToReadCredential(e);
        }
        catch (UnsupportedCredentialTypeException e) {
            return null;
        }
        if (credentialType.isInstance(credential) && (parameterSpec == null || credential.impliesParameters(parameterSpec)) && (algorithmName == null || credential instanceof AlgorithmCredential && algorithmName.equals(((AlgorithmCredential)credential).getAlgorithm()))) {
            return credential;
        }
        return null;
    }
}

