/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.cache;

import java.io.Serializable;
import java.security.Principal;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;

public final class CachedIdentity
implements Serializable {
    private static final long serialVersionUID = 750487522862481938L;
    private final String mechanismName;
    private final String name;
    private final transient SecurityIdentity securityIdentity;

    public CachedIdentity(String mechanismName, SecurityIdentity securityIdentity) {
        Assert.checkNotNullParam((String)"mechanismName", (Object)mechanismName);
        Assert.checkNotNullParam((String)"securityIdentity", (Object)securityIdentity);
        Principal principal = securityIdentity.getPrincipal();
        Assert.checkNotNullParam((String)"principal", (Object)principal);
        Assert.checkNotNullParam((String)"name", (Object)principal.getName());
        this.mechanismName = mechanismName;
        this.name = principal.getName();
        this.securityIdentity = securityIdentity;
    }

    public String getMechanismName() {
        return this.mechanismName;
    }

    public String getName() {
        return this.name;
    }

    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }
}

