/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import org.wildfly.common.Assert;

public class AttributeMapping {
    private final String ldapName;
    private final String searchDn;
    private final String filter;
    private String name;
    private String rdn;

    public static AttributeMapping from(String ldapName) {
        Assert.checkNotNullParam((String)"ldapName", (Object)ldapName);
        return new AttributeMapping(ldapName);
    }

    public static AttributeMapping fromFilter(String searchDn, String filter, String ldapName) {
        Assert.checkNotNullParam((String)"searchDn", (Object)searchDn);
        Assert.checkNotNullParam((String)"filter", (Object)filter);
        Assert.checkNotNullParam((String)"ldapName", (Object)ldapName);
        return new AttributeMapping(searchDn, filter, ldapName);
    }

    public static AttributeMapping fromFilter(String filter, String ldapName) {
        Assert.checkNotNullParam((String)"filter", (Object)filter);
        Assert.checkNotNullParam((String)"ldapName", (Object)ldapName);
        return new AttributeMapping(null, filter, ldapName);
    }

    AttributeMapping(String ldapName) {
        this(null, null, ldapName);
    }

    AttributeMapping(String searchDn, String filter, String ldapName) {
        Assert.checkNotNullParam((String)"ldapName", (Object)ldapName);
        this.searchDn = searchDn;
        this.filter = filter;
        this.ldapName = ldapName.toUpperCase();
    }

    public AttributeMapping asRdn(String rdn) {
        Assert.checkNotNullParam((String)"rdn", (Object)rdn);
        this.rdn = rdn;
        return this;
    }

    public AttributeMapping to(String name) {
        Assert.checkNotNullParam((String)"to", (Object)name);
        this.name = name;
        return this;
    }

    String getLdapName() {
        return this.ldapName;
    }

    String getName() {
        if (this.name == null) {
            return this.ldapName;
        }
        return this.name;
    }

    String getSearchDn() {
        return this.searchDn;
    }

    String getFilter() {
        return this.filter;
    }

    String getRdn() {
        return this.rdn;
    }
}

