/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import org.wildfly.common.Assert;
import org.wildfly.security.password.OneWayPassword;
import org.wildfly.security.password.interfaces.RawUnixSHACryptPassword;

public interface UnixSHACryptPassword
extends OneWayPassword {
    public static final String ALGORITHM_CRYPT_SHA_256 = "crypt-sha-256";
    public static final String ALGORITHM_CRYPT_SHA_512 = "crypt-sha-512";
    public static final int SALT_SIZE = 16;
    public static final int DEFAULT_ITERATION_COUNT = 5000;

    public byte[] getSalt();

    public byte[] getHash();

    public int getIterationCount();

    @Override
    public UnixSHACryptPassword clone();

    public static UnixSHACryptPassword createRaw(String algorithm, byte[] salt, byte[] hash, int iterationCount) {
        Assert.checkNotNullParam((String)"algorithm", (Object)algorithm);
        Assert.checkNotNullParam((String)"salt", (Object)salt);
        Assert.checkNotNullParam((String)"hash", (Object)hash);
        return new RawUnixSHACryptPassword(algorithm, salt, hash, iterationCount);
    }
}

