/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import org.wildfly.common.Assert;
import org.wildfly.security.password.OneWayPassword;
import org.wildfly.security.password.interfaces.RawSunUnixMD5CryptPassword;

public interface SunUnixMD5CryptPassword
extends OneWayPassword {
    public static final String ALGORITHM_SUN_CRYPT_MD5 = "sun-crypt-md5";
    public static final String ALGORITHM_SUN_CRYPT_MD5_BARE_SALT = "sun-crypt-md5-bare-salt";
    public static final int DEFAULT_SALT_SIZE = 8;
    public static final int DEFAULT_ITERATION_COUNT = 5500;

    public byte[] getSalt();

    public byte[] getHash();

    public int getIterationCount();

    @Override
    public SunUnixMD5CryptPassword clone();

    public static SunUnixMD5CryptPassword createRaw(String algorithm, byte[] salt, byte[] hash, int iterationCount) {
        Assert.checkNotNullParam((String)"algorithm", (Object)algorithm);
        Assert.checkNotNullParam((String)"salt", (Object)salt);
        Assert.checkNotNullParam((String)"hash", (Object)hash);
        return new RawSunUnixMD5CryptPassword(algorithm, salt, hash, iterationCount);
    }
}

